/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import java.util.Iterator;

public class CommentTypeFilterAddressIterator
implements AddressIterator {
    private AddressIterator it;
    private Listing listing;
    private CommentType commentType;
    private Address nextAddr;

    public CommentTypeFilterAddressIterator(Program program, AddressIterator it, CommentType commentType) {
        this.listing = program.getListing();
        this.it = it;
        this.commentType = commentType;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.nextAddr == null) {
            this.findNext();
        }
        return this.nextAddr != null;
    }

    @Override
    public Address next() {
        if (this.hasNext()) {
            Address ret = this.nextAddr;
            this.nextAddr = null;
            return ret;
        }
        return null;
    }

    private void findNext() {
        while (this.it.hasNext()) {
            Address addr = this.it.next();
            if (this.listing.getComment(this.commentType, addr) == null) continue;
            this.nextAddr = addr;
            break;
        }
    }

    @Override
    public Iterator<Address> iterator() {
        return this;
    }
}

