/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.translate;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.address.Address;
import ghidra.pcodeCPort.address.RangeList;
import ghidra.pcodeCPort.error.LowlevelError;
import ghidra.pcodeCPort.pcoderaw.VarnodeData;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.pcodeCPort.translate.BasicSpaceProvider;
import ghidra.pcodeCPort.utils.AddrSpaceToIdSymmetryMap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Translate
implements BasicSpaceProvider {
    private long unique_base = 0L;
    private List<AddrSpace> baselist = new ArrayList<AddrSpace>();
    private AddrSpace constantspace;
    private AddrSpace defaultspace;
    private AddrSpace iopspace;
    private AddrSpace fspecspace;
    private AddrSpace stackspace;
    private AddrSpace uniqspace;
    private VectorSTL<VectorSTL<VarnodeData>> spacebaselist = new VectorSTL();
    protected RangeList nohighptr = new RangeList();
    protected int alignment = 1;
    protected int target_endian;

    protected void setUniqueBase(long val) {
        if (val > this.unique_base) {
            this.unique_base = val;
        }
    }

    public boolean isBigEndian() {
        return this.target_endian == 1;
    }

    @Deprecated
    public int getAddrSize() {
        return this.defaultspace.getAddrSize();
    }

    public int getDefaultSize() {
        return this.defaultspace.getAddrSize();
    }

    int getAlignment() {
        return this.alignment;
    }

    public long getUniqueBase() {
        return this.unique_base;
    }

    public AddrSpace getIopSpace() {
        return this.iopspace;
    }

    public AddrSpace getFspecSpace() {
        return this.fspecspace;
    }

    public AddrSpace getStackSpace() {
        return this.stackspace;
    }

    public AddrSpace getUniqueSpace() {
        return this.uniqspace;
    }

    @Override
    public AddrSpace getDefaultSpace() {
        return this.defaultspace;
    }

    @Override
    public AddrSpace getConstantSpace() {
        return this.constantspace;
    }

    public Address getConstant(long val) {
        return new Address(this.constantspace, val);
    }

    public Address createConstFromSpace(AddrSpace spc) {
        long id = AddrSpaceToIdSymmetryMap.getID(spc);
        return new Address(this.constantspace, id);
    }

    public int numSpaces() {
        return this.baselist.size();
    }

    public AddrSpace getSpace(int i) {
        return this.baselist.get(i);
    }

    public boolean highPtrPossible(Address loc, int size) {
        return !this.nohighptr.inRange(loc, size);
    }

    protected void registerContext(String name, int sbit, int ebit) {
    }

    public abstract VarnodeData getRegister(String var1);

    public abstract String getRegisterName(AddrSpace var1, long var2, int var4);

    public abstract void getUserOpNames(VectorSTL<String> var1);

    public abstract int instructionLength(Address var1);

    public abstract int printAssembly(PrintStream var1, int var2, Address var3);

    public AddrSpace getSpaceByName(String nm) {
        for (AddrSpace space : this.baselist) {
            if (!space.getName().equals(nm)) continue;
            return space;
        }
        return null;
    }

    public AddrSpace getSpaceByShortcut(char sc) {
        for (AddrSpace space : this.baselist) {
            if (space.getShortCut() != sc) continue;
            return space;
        }
        return null;
    }

    public void addSpacebase(AddrSpace basespace, AddrSpace spc, long offset, int size) {
        int index = basespace.getIndex();
        while (index >= this.spacebaselist.size()) {
            this.spacebaselist.push_back((Object)new VectorSTL());
        }
        VectorSTL datalist = (VectorSTL)this.spacebaselist.get(index);
        datalist.push_back((Object)new VarnodeData());
        ((VarnodeData)datalist.back()).space = spc;
        ((VarnodeData)datalist.back()).offset = offset;
        ((VarnodeData)datalist.back()).size = size;
    }

    public int numSpacebase(AddrSpace basespace) {
        int index = basespace.getIndex();
        if (index >= this.spacebaselist.size()) {
            return 0;
        }
        return ((VectorSTL)this.spacebaselist.get(index)).size();
    }

    public VarnodeData getSpacebase(AddrSpace basespace, int i) {
        VectorSTL datalist;
        int index = basespace.getIndex();
        if (index < this.spacebaselist.size() && i < (datalist = (VectorSTL)this.spacebaselist.get(index)).size()) {
            return (VarnodeData)datalist.get(i);
        }
        throw new LowlevelError("Space base register does not exist for space: " + basespace.getName());
    }

    public void insertSpace(AddrSpace spc) {
        boolean nametype_mismatch = false;
        boolean duplicatedefine = false;
        switch (spc.getType()) {
            case IPTR_CONSTANT: {
                if (!spc.getName().equals("const")) {
                    nametype_mismatch = true;
                }
                if (this.baselist.size() != 0) {
                    throw new LowlevelError("const space must be initialized first");
                }
                this.constantspace = spc;
                break;
            }
            case IPTR_INTERNAL: {
                if (!spc.getName().equals("unique")) {
                    nametype_mismatch = true;
                }
                if (this.uniqspace != null) {
                    duplicatedefine = true;
                }
                this.uniqspace = spc;
                break;
            }
            case IPTR_FSPEC: {
                if (!spc.getName().equals("fspec")) {
                    nametype_mismatch = true;
                }
                if (this.fspecspace != null) {
                    duplicatedefine = true;
                }
                this.fspecspace = spc;
                break;
            }
            case IPTR_IOP: {
                if (!spc.getName().equals("iop")) {
                    nametype_mismatch = true;
                }
                if (this.iopspace != null) {
                    duplicatedefine = true;
                }
                this.iopspace = spc;
                break;
            }
            case IPTR_SPACEBASE: {
                if (spc.getName().equals("stack")) {
                    if (this.stackspace != null) {
                        duplicatedefine = true;
                    }
                    this.stackspace = spc;
                }
            }
            case IPTR_PROCESSOR: {
                if (spc.isOtherSpace() && spc.getIndex() != 1) {
                    throw new LowlevelError("OTHER space must be assigned index 1");
                }
                for (AddrSpace space : this.baselist) {
                    if (!space.getName().equals(spc.getName())) continue;
                    duplicatedefine = true;
                }
                break;
            }
        }
        if (nametype_mismatch) {
            throw new LowlevelError("Space " + spc.getName() + " was initialized with wrong type");
        }
        if (duplicatedefine) {
            throw new LowlevelError("Space " + spc.getName() + " was initialized more than once");
        }
        if (this.baselist.size() != spc.getIndex()) {
            throw new LowlevelError("Space " + spc.getName() + " was initialized with a bad id");
        }
        this.baselist.add(spc);
    }

    public void setDefaultSpace(int index) {
        if (this.defaultspace != null) {
            throw new LowlevelError("Default space set multiple times");
        }
        if (this.baselist.size() <= index) {
            throw new LowlevelError("Bad index for default space");
        }
        this.defaultspace = this.baselist.get(index);
    }

    public char assignShortcut(spacetype tp) {
        char shortcut = 'x';
        switch (tp) {
            case IPTR_CONSTANT: {
                shortcut = '#';
                break;
            }
            case IPTR_PROCESSOR: {
                shortcut = 'r';
                break;
            }
            case IPTR_SPACEBASE: {
                shortcut = 's';
                break;
            }
            case IPTR_INTERNAL: {
                shortcut = 'u';
                break;
            }
            case IPTR_FSPEC: {
                shortcut = 'f';
                break;
            }
            case IPTR_IOP: {
                shortcut = 'i';
            }
        }
        for (int i = 97; i < 122; ++i) {
            int j;
            for (j = 0; j < this.baselist.size() && this.baselist.get(j).getShortCut() != shortcut; ++j) {
            }
            if (j == this.baselist.size()) {
                return shortcut;
            }
            shortcut = (char)i;
        }
        throw new LowlevelError("Unable to assign shortcut");
    }

    public AddrSpace getNextSpaceInOrder(AddrSpace spc) {
        int nextIndex = spc.getIndex() + 1;
        if (nextIndex >= 0 && nextIndex < this.baselist.size()) {
            return this.baselist.get(nextIndex);
        }
        return AddrSpace.MAX_SPACE;
    }

    public AddrSpace getSpaceBySpacebase(Address loc, int size) {
        Iterator<AddrSpace> iterator = this.baselist.iterator();
        while (iterator.hasNext()) {
            AddrSpace element;
            AddrSpace id = element = iterator.next();
            int numspace = this.numSpacebase(id);
            for (int j = 0; j < numspace; ++j) {
                VarnodeData point = this.getSpacebase(id, j);
                if (point.size != size || point.space != loc.getSpace() || point.offset != loc.getOffset()) continue;
                return id;
            }
        }
        throw new LowlevelError("Unable to find entry for spacebase register");
    }

    public void dispose() {
    }

    public void setLanguage(String processorFile) {
    }
}

