/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.generic;

import ghidra.framework.store.LockException;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.mem.ByteMappingScheme;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.InvalidAddressException;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockException;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.util.Msg;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributeException;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;
import java.util.List;

public class MemoryBlockDefinition {
    private final String blockName;
    private final String addressString;
    private final int length;
    private final boolean initialized;
    private final boolean overlay;
    private final String bitMappedAddress;
    private final String byteMappedAddress;
    private final ByteMappingScheme byteMappingScheme;
    private final String mode;
    private final boolean readPermission;
    private final boolean writePermission;
    private final boolean executePermission;
    private final boolean isVolatile;
    private static final String DEFAULT_MODE = "rw";

    private MemoryBlockDefinition(String blockName, String addressString, String bitMappedAddress, String byteMappedAddressRatio, String mode, String lengthString, String initializedString, String overlayString) throws XmlAttributeException {
        this.mode = mode != null ? mode.toLowerCase() : DEFAULT_MODE;
        this.readPermission = this.mode.indexOf(114) >= 0;
        this.writePermission = this.mode.indexOf(119) >= 0;
        this.executePermission = this.mode.indexOf(120) >= 0;
        boolean bl = this.isVolatile = this.mode.indexOf(118) >= 0;
        if (blockName == null) {
            throw new XmlAttributeException("Missing default memory block 'name'");
        }
        this.blockName = blockName;
        if (addressString == null) {
            throw new XmlAttributeException("Missing default memory block 'start_address'");
        }
        this.addressString = addressString;
        this.bitMappedAddress = bitMappedAddress;
        if (byteMappedAddressRatio != null) {
            if (bitMappedAddress != null) {
                throw new XmlAttributeException("may not specify both bit_mapped_address and byte_mapped_address");
            }
            int index = byteMappedAddressRatio.indexOf(47);
            if (index > 0) {
                this.byteMappingScheme = new ByteMappingScheme(byteMappedAddressRatio.substring(index + 1));
                this.byteMappedAddress = byteMappedAddressRatio.substring(0, index);
            } else {
                this.byteMappingScheme = null;
                this.byteMappedAddress = byteMappedAddressRatio;
            }
        } else {
            this.byteMappedAddress = null;
            this.byteMappingScheme = null;
        }
        int parsedLen = -1;
        try {
            parsedLen = XmlUtilities.parseInt((String)lengthString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (parsedLen <= 0) {
            throw new XmlAttributeException(lengthString + " is not a valid 'length'");
        }
        this.length = parsedLen;
        if (initializedString != null && (bitMappedAddress != null || this.byteMappedAddress != null)) {
            throw new XmlAttributeException("mapped block specifications must not specify initialized attribute");
        }
        this.initialized = XmlUtilities.parseBoolean((String)initializedString);
        this.overlay = XmlUtilities.parseBoolean((String)overlayString);
    }

    public MemoryBlockDefinition(XmlElement element) throws XmlAttributeException {
        this(element.getAttribute("name"), element.getAttribute("start_address"), element.getAttribute("bit_mapped_address"), element.getAttribute("byte_mapped_address"), element.getAttribute("mode"), element.getAttribute("length"), element.getAttribute("initialized"), element.getAttribute("overlay"));
    }

    private static Address parseAddress(String addressString, Program program, String description) throws InvalidAddressException {
        Address addr = XmlProgramUtilities.parseAddress(program.getAddressFactory(), addressString);
        if (addr == null) {
            throw new InvalidAddressException("Invalid " + description + " in memory block definition: " + addressString);
        }
        return addr;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public MemoryBlock fixupBlock(ProgramDB program) throws LockException, MemoryBlockException {
        Address currentStartAddress;
        Address addr;
        program.checkExclusiveAccess();
        MemoryMapDB memory = program.getMemory();
        MemoryBlock block = memory.getBlock(this.blockName);
        if (block == null) {
            try {
                Msg.info((Object)this, (Object)("Adding process-defined memory block: " + this.blockName));
                return this.createBlock(program);
            }
            catch (AddressOverflowException | InvalidAddressException | MemoryConflictException e) {
                throw new MemoryBlockException("Create block failed", (Throwable)e);
            }
        }
        MemoryBlockType blockType = this.getBlockType();
        List<MemoryBlockSourceInfo> sourceInfos = block.getSourceInfos();
        if (!blockType.equals((Object)block.getType()) || this.overlay != block.isOverlay() || sourceInfos.size() != 1) {
            throw new MemoryBlockException("Incompatible memory block type");
        }
        MemoryBlockSourceInfo sourceInfo = sourceInfos.get(0);
        try {
            Address mappedAddr;
            addr = MemoryBlockDefinition.parseAddress(this.addressString, program, "block address");
            currentStartAddress = block.getStart();
            AddressSpace currentAddressSpace = currentStartAddress.getAddressSpace();
            if (currentAddressSpace instanceof OverlayAddressSpace) {
                OverlayAddressSpace overlaySpace = (OverlayAddressSpace)currentAddressSpace;
                if (overlaySpace.getOverlayedSpace().equals(addr.getAddressSpace())) {
                    throw new MemoryBlockException("Incompatible overlay memory block");
                }
                addr = overlaySpace.getAddressInThisSpaceOnly(addr.getOffset());
            }
            if (this.bitMappedAddress != null) {
                mappedAddr = MemoryBlockDefinition.parseAddress(this.bitMappedAddress, program, "bit-mapped address");
                if (addr.equals(currentStartAddress) && sourceInfo.getMappedRange().isPresent() && mappedAddr.equals(sourceInfo.getMappedRange().get().getMinAddress()) && (long)this.length == block.getSize()) {
                    return block;
                }
                throw new MemoryBlockException("inconsistent bit-mapped block");
            }
            if (this.byteMappedAddress != null) {
                mappedAddr = MemoryBlockDefinition.parseAddress(this.byteMappedAddress, program, "byte-mapped address");
                if (addr.equals(currentStartAddress) && sourceInfo.getMappedRange().isPresent() && mappedAddr.equals(sourceInfo.getMappedRange().get().getMinAddress()) && (long)this.length == block.getSize()) {
                    return block;
                }
                throw new MemoryBlockException("inconsistent byte-mapped block");
            }
        }
        catch (InvalidAddressException e) {
            throw new MemoryBlockException("failed to process processor block address", (Throwable)((Object)e));
        }
        if (sourceInfo.getFileBytes().isPresent() || sourceInfo.getMappedRange().isPresent()) {
            throw new MemoryBlockException("unsupported file or memory-mapped block");
        }
        if (!addr.equals(currentStartAddress)) {
            throw new MemoryBlockException("inconsistent block start address: " + String.valueOf(addr) + " / " + String.valueOf(currentStartAddress));
        }
        try {
            if ((long)this.length > block.getSize()) {
                Msg.info((Object)this, (Object)("Expanding processor defined memory block from " + block.getSize() + "-bytes to " + this.length + "-bytes: " + this.blockName));
                MemoryBlock newBlock = memory.createBlock(block, block.getName() + ".exp", block.getEnd().next(), (long)this.length - block.getSize());
                MemoryBlock b = memory.join(block, newBlock);
                if (!b.getName().equals(this.blockName)) {
                    b.setName(this.blockName);
                }
            } else {
                Msg.warn((Object)this, (Object)("Ignored processor block size reduction: " + this.blockName));
            }
            boolean accessAdjusted = false;
            if (this.readPermission != block.isRead()) {
                block.setRead(this.readPermission);
                accessAdjusted = true;
            }
            if (this.writePermission != block.isWrite()) {
                block.setWrite(this.writePermission);
                accessAdjusted = true;
            }
            if (this.executePermission != block.isExecute()) {
                block.setExecute(this.executePermission);
                accessAdjusted = true;
            }
            if (this.isVolatile != block.isVolatile()) {
                block.setVolatile(this.isVolatile);
                accessAdjusted = true;
            }
            if (accessAdjusted) {
                Msg.warn((Object)this, (Object)("Updated processor block access mode (" + this.mode + "): " + this.blockName));
            }
        }
        catch (AddressOverflowException | MemoryConflictException | IllegalArgumentException e) {
            throw new MemoryBlockException("block adjustment failed", (Throwable)e);
        }
        return block;
    }

    private MemoryBlockType getBlockType() {
        if (this.bitMappedAddress != null) {
            return MemoryBlockType.BIT_MAPPED;
        }
        if (this.byteMappedAddress != null) {
            return MemoryBlockType.BYTE_MAPPED;
        }
        return MemoryBlockType.DEFAULT;
    }

    public MemoryBlock createBlock(Program program) throws LockException, MemoryConflictException, AddressOverflowException, InvalidAddressException {
        MemoryBlock block;
        Memory mem = program.getMemory();
        Address addr = MemoryBlockDefinition.parseAddress(this.addressString, program, "block address");
        if (this.bitMappedAddress != null) {
            Address mappedAddr = MemoryBlockDefinition.parseAddress(this.bitMappedAddress, program, "bit-mapped address");
            block = mem.createBitMappedBlock(this.blockName, addr, mappedAddr, this.length, this.overlay);
        } else if (this.byteMappedAddress != null) {
            Address mappedAddr = MemoryBlockDefinition.parseAddress(this.byteMappedAddress, program, "byte-mapped address");
            block = mem.createByteMappedBlock(this.blockName, addr, mappedAddr, this.length, this.byteMappingScheme, this.overlay);
        } else if (this.initialized) {
            try {
                block = mem.createInitializedBlock(this.blockName, addr, this.length, (byte)0, TaskMonitor.DUMMY, this.overlay);
            }
            catch (CancelledException e) {
                throw new AssertException((Throwable)e);
            }
        } else {
            block = mem.createUninitializedBlock(this.blockName, addr, this.length, this.overlay);
        }
        block.setRead(this.readPermission);
        block.setWrite(this.writePermission);
        block.setExecute(this.executePermission);
        block.setVolatile(this.isVolatile);
        return block;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.blockName);
        buf.append(':');
        if (this.overlay) {
            buf.append("overlay");
        }
        buf.append(" start_address=");
        buf.append(this.addressString);
        if (this.initialized) {
            buf.append(", initialized ");
        } else if (this.bitMappedAddress != null) {
            buf.append(", bit_mapped_address=");
            buf.append(this.bitMappedAddress);
        } else if (this.byteMappedAddress != null) {
            buf.append(", byte_mapped_address=");
            buf.append(this.byteMappedAddress);
            if (this.byteMappingScheme != null) {
                buf.append('/');
                buf.append(this.byteMappingScheme.toString());
            }
        } else {
            buf.append(", uninitialized");
        }
        buf.append(", length=0x");
        buf.append(Integer.toHexString(this.length));
        return buf.toString();
    }
}

