/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyProduction;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyDefaultContext;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNonTerminal;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GEdgeWeightMetric;
import ghidra.graph.GImplicitDirectedGraph;
import ghidra.graph.GraphFactory;
import ghidra.graph.algo.DijkstraShortestPathsAlgorithm;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.LazyMap;

public class AssemblyContextGraph
implements GImplicitDirectedGraph<Vertex, Edge> {
    protected final AbstractAssemblyResolutionFactory<?, ?> factory;
    protected final Map<String, Set<AssemblyConstructorSemantic>> semantics = LazyMap.lazyMap(new HashMap(), () -> new HashSet());
    protected final AssemblyGrammar grammar;
    protected final SleighLanguage lang;
    protected final DijkstraShortestPathsAlgorithm<Vertex, Edge> dijkstra;
    protected final Set<Vertex> cachedVertices = new HashSet<Vertex>();
    protected final Set<Edge> cachedEdges = new HashSet<Edge>();
    protected final Map<Vertex, Set<Edge>> cachedOutEdges = LazyMap.lazyMap(new HashMap(), v -> this.computeOutEdges((Vertex)v));

    public AssemblyContextGraph(AbstractAssemblyResolutionFactory<?, ?> factory, SleighLanguage lang, AssemblyGrammar grammar) {
        this.factory = factory;
        this.grammar = grammar;
        this.lang = lang;
        this.gatherSemantics();
        AssemblyDefaultContext ctx = new AssemblyDefaultContext(lang);
        AssemblyPatternBlock defctx = ctx.getDefault();
        defctx = defctx.fillMask();
        Vertex v2 = new Vertex(defctx, grammar.getStartName());
        this.dijkstra = new DijkstraShortestPathsAlgorithm((GImplicitDirectedGraph)this, (double)this.semantics.get(grammar.getStartName()).size(), GEdgeWeightMetric.unitMetric());
        this.dijkstra.getDistancesFromSource((Object)v2);
    }

    public Collection<Deque<AssemblyConstructorSemantic>> computeOptimalApplications(AssemblyPatternBlock src, String srcTable, AssemblyPatternBlock dst, String dstTable) {
        Vertex s = new Vertex(src, srcTable);
        Vertex xd = new Vertex(dst, dstTable);
        HashSet<Vertex> bestDests = new HashSet<Vertex>();
        Double bestDist = null;
        for (Map.Entry ent : this.dijkstra.getDistancesFromSource((Object)s).entrySet()) {
            if (!((Vertex)ent.getKey()).matches(xd)) continue;
            if (bestDist == null || (Double)ent.getValue() < bestDist) {
                bestDests.clear();
                bestDests.add((Vertex)ent.getKey());
                bestDist = (Double)ent.getValue();
                continue;
            }
            if (!bestDist.equals(ent.getValue())) continue;
            bestDests.add((Vertex)ent.getKey());
        }
        HashSet<Deque<AssemblyConstructorSemantic>> result = new HashSet<Deque<AssemblyConstructorSemantic>>();
        for (Vertex d : bestDests) {
            Collection optimalPaths = this.dijkstra.computeOptimalPaths((Object)s, (Object)d);
            for (Deque path : optimalPaths) {
                LinkedList<AssemblyConstructorSemantic> sems = new LinkedList<AssemblyConstructorSemantic>();
                for (Edge e : path) {
                    sems.add(e.sem);
                }
                result.add(sems);
            }
        }
        return result;
    }

    protected void gatherSemantics() {
        AssemblyProduction rec = this.grammar.getPureRecursion((AssemblyNonTerminal)this.grammar.getNonTerminal(this.grammar.getStartName()));
        if (rec == null) {
            return;
        }
        for (AssemblyConstructorSemantic sem : this.grammar.getSemantics(rec)) {
            this.semantics.get(this.grammar.getStartName()).add(sem);
        }
    }

    protected Set<Edge> computeOutEdges(Vertex from) {
        this.cachedVertices.add(from);
        HashSet<Edge> result = new HashSet<Edge>();
        for (AssemblyConstructorSemantic sem : this.semantics.get(from.subtable)) {
            for (AssemblyResolvedPatterns rc : sem.patterns) {
                AssemblyPatternBlock pattern = rc.getContext();
                AssemblyPatternBlock outer = from.context.combine(pattern);
                if (outer == null || sem.getConstructor().getNumOperands() == 0) continue;
                Object orc = this.factory.contextOnly(outer, "For context transition");
                AssemblyResolvedPatterns irc = sem.applyContextChangesForward(Map.of(), (AssemblyResolvedPatterns)orc);
                AssemblyPatternBlock inner = irc.getContext();
                Constructor ct = sem.getConstructor();
                for (int i = 0; i < ct.getNumOperands(); ++i) {
                    SubtableSymbol subtable;
                    OperandSymbol op = ct.getOperand(i);
                    TripleSymbol def = op.getDefiningSymbol();
                    if (!(def instanceof SubtableSymbol) || !from.subtable.equals((subtable = (SubtableSymbol)def).getName())) continue;
                    Vertex dest = new Vertex(inner, subtable.getName());
                    this.cachedVertices.add(dest);
                    Edge e = new Edge(sem, i, from, dest);
                    this.cachedEdges.add(e);
                    result.add(e);
                }
            }
        }
        return result;
    }

    public Collection<Edge> getInEdges(Vertex v) {
        throw new UnsupportedOperationException("Does not support backward traversal");
    }

    public Collection<Edge> getOutEdges(Vertex v) {
        return this.cachedOutEdges.get(v);
    }

    public GDirectedGraph<Vertex, Edge> copy() {
        GDirectedGraph graph = GraphFactory.createDirectedGraph();
        for (Vertex v : this.cachedVertices) {
            graph.addVertex((Object)v);
        }
        for (Edge e : this.cachedEdges) {
            graph.addEdge((GEdge)e);
        }
        return graph;
    }

    protected static class Vertex
    implements Comparable<Vertex> {
        protected final AssemblyPatternBlock context;
        protected final String subtable;

        protected Vertex(AssemblyPatternBlock context, String subtable) {
            this.context = context;
            this.subtable = subtable;
        }

        public boolean matches(Vertex that) {
            if (!this.subtable.equals(that.subtable)) {
                return false;
            }
            return this.context.combine(that.context) != null;
        }

        public int hashCode() {
            return this.context.hashCode() * 31 + this.subtable.hashCode();
        }

        public String toString() {
            return "ctx:" + String.valueOf(this.context) + " at " + this.subtable;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Vertex)) {
                return false;
            }
            Vertex that = (Vertex)o;
            if (!this.context.equals(that.context)) {
                return false;
            }
            return this.subtable.equals(that.subtable);
        }

        @Override
        public int compareTo(Vertex that) {
            int result = this.context.compareTo(that.context);
            if (result != 0) {
                return result;
            }
            result = this.subtable.compareTo(that.subtable);
            if (result != 0) {
                return result;
            }
            return 0;
        }
    }

    protected static class Edge
    implements GEdge<Vertex>,
    Comparable<Edge> {
        protected final AssemblyConstructorSemantic sem;
        protected final int op;
        protected final Vertex start;
        protected final Vertex end;

        public Edge(AssemblyConstructorSemantic sem, int op, Vertex start, Vertex end) {
            this.sem = sem;
            this.op = op;
            this.start = start;
            this.end = end;
        }

        public int hashCode() {
            int result = this.sem.hashCode();
            result *= 31;
            result += Integer.hashCode(this.op);
            result *= 31;
            result += this.start.hashCode();
            result *= 31;
            return result += this.end.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Edge)) {
                return false;
            }
            Edge that = (Edge)o;
            if (!this.sem.equals(that.sem)) {
                return false;
            }
            if (this.op != that.op) {
                return false;
            }
            if (!this.start.equals(that.start)) {
                return false;
            }
            return this.end.equals(that.end);
        }

        @Override
        public int compareTo(Edge that) {
            int result = this.sem.compareTo(that.sem);
            if (result != 0) {
                return result;
            }
            result = this.op - that.op;
            if (result != 0) {
                return result;
            }
            result = this.start.compareTo(that.start);
            if (result != 0) {
                return result;
            }
            result = this.end.compareTo(that.end);
            if (result != 0) {
                return result;
            }
            return 0;
        }

        public String toString() {
            return String.valueOf(this.start) + " --[" + String.valueOf(this.sem) + " op " + this.op + "]-> " + String.valueOf(this.end);
        }

        public Vertex getStart() {
            return this.start;
        }

        public Vertex getEnd() {
            return this.end;
        }
    }
}

