/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyTreeResolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

public abstract class AbstractAssemblyState {
    protected final AbstractAssemblyTreeResolver<?> resolver;
    protected final AbstractAssemblyResolutionFactory<?, ?> factory;
    protected final List<AssemblyConstructorSemantic> path;
    protected final int shift;
    protected final int length;
    protected volatile boolean hasHash = false;
    protected volatile int hash;

    protected AbstractAssemblyState(AbstractAssemblyTreeResolver<?> resolver, List<AssemblyConstructorSemantic> path, int shift, int length) {
        this.resolver = resolver;
        this.factory = resolver.factory;
        this.path = path;
        this.shift = shift;
        this.length = length;
    }

    public int hashCode() {
        if (!this.hasHash) {
            this.hash = this.computeHash();
            this.hasHash = true;
        }
        return this.hash;
    }

    public abstract int computeHash();

    public abstract boolean equals(Object var1);

    protected abstract Stream<AssemblyResolvedPatterns> resolve(AssemblyResolvedPatterns var1, Collection<AssemblyResolvedError> var2);

    public AbstractAssemblyTreeResolver<?> getResolver() {
        return this.resolver;
    }

    public List<AssemblyConstructorSemantic> getPath() {
        return this.path;
    }

    public int getShift() {
        return this.shift;
    }

    public int getLength() {
        return this.length;
    }
}

