/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.trable;

import generic.theme.GThemeDefaults;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class OpenCloseIcon
implements Icon {
    private int width;
    private int height;
    private int[] xPoints;
    private int[] yPoints;
    private Color color = GThemeDefaults.Colors.FOREGROUND;

    public OpenCloseIcon(boolean isOpen, int width, int height) {
        this.width = width;
        this.height = height;
        if (isOpen) {
            this.buildDownPointingTriangle();
        } else {
            this.buildRightPointingTriangle();
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    private void buildDownPointingTriangle() {
        int triangleWidth = 8;
        int triangleHeight = 4;
        int startX = this.width / 2 - triangleWidth / 2;
        int endX = startX + triangleWidth;
        int startY = this.height / 2 - triangleHeight / 2;
        int endY = startY + triangleHeight;
        this.xPoints = new int[]{startX, endX, (startX + endX) / 2};
        this.yPoints = new int[]{startY, startY, endY};
    }

    private void buildRightPointingTriangle() {
        int triangleWidth = 4;
        int triangleHeight = 8;
        int startX = this.width / 2 - triangleWidth / 2;
        int endX = startX + triangleWidth;
        int startY = this.height / 2 - triangleHeight / 2;
        int endY = startY + triangleHeight;
        this.xPoints = new int[]{startX, endX, startX};
        this.yPoints = new int[]{startY, (startY + endY) / 2, endY};
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.color);
        g.translate(x, y);
        Graphics2D graphics2D = (Graphics2D)g;
        graphics2D.drawPolygon(this.xPoints, this.yPoints, 3);
        graphics2D.fillPolygon(this.xPoints, this.yPoints, 3);
        g.translate(-x, -y);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

