/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.dnd.GClipboard;
import docking.dnd.StringTransferable;
import docking.options.editor.HistorySwatchPanel;
import docking.options.editor.MainSwatchPanel;
import docking.options.editor.RecentSwatchPanel;
import docking.options.editor.SwatchPanel;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import generic.theme.GThemeDefaults;
import ghidra.util.WebColors;
import ghidra.util.layout.HorizontalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.datatransfer.Clipboard;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class SettableColorSwatchChooserPanel
extends AbstractColorChooserPanel {
    private SwatchPanel swatchPanel;
    private RecentSwatchPanel recentSwatchPanel;
    private HistorySwatchPanel historySwatchPanel;
    private JTextField colorNameField;
    private GDLabel colorValueLabel;
    private MainSwatchListener mainSwatchListener;
    private MouseListener recentSwatchListener;
    private MouseListener historySwatchListener;
    private DocumentListener colorNameListener;
    private ChangeListener colorValueUpdateListener;
    private String recentText = UIManager.getString("ColorChooser.swatchesRecentText");
    private List<Color> historyColors;

    public void setHistoryColors(List<Color> historyColors) {
        this.historyColors = historyColors;
        if (this.historySwatchPanel != null) {
            this.historySwatchPanel.setHistoryColors(historyColors);
        }
    }

    public List<Color> getHistoryColors() {
        return this.historyColors;
    }

    public void setRecentColors(List<Color> recentColors) {
        if (this.recentSwatchPanel != null) {
            this.recentSwatchPanel.setRecentColors(recentColors);
        }
    }

    public List<Color> getRecentColors() {
        if (this.recentSwatchPanel != null) {
            return this.recentSwatchPanel.getRecentColors();
        }
        return Collections.emptyList();
    }

    @Override
    public String getDisplayName() {
        return UIManager.getString("ColorChooser.swatchesNameText");
    }

    private int overriddenGetInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public int getMnemonic() {
        return this.overriddenGetInt("ColorChooser.swatchesMnemonic", -1);
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return this.overriddenGetInt("ColorChooser.swatchesDisplayedMnemonicIndex", -1);
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
    }

    @Override
    protected void buildChooser() {
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel superHolder = new JPanel(gb);
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.getAccessibleContext().setAccessibleName(this.getDisplayName());
        this.recentSwatchPanel = new RecentSwatchPanel();
        this.recentSwatchPanel.getAccessibleContext().setAccessibleName(this.recentText);
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.recentSwatchListener = new RecentSwatchListener();
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        LineBorder border = new LineBorder((Color)GThemeDefaults.Colors.BORDER);
        this.swatchPanel.setBorder(border);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 2;
        gbc.weighty = 1.0;
        gbc.anchor = 19;
        superHolder.add((Component)this.swatchPanel, gbc);
        this.recentSwatchPanel.setBorder(border);
        GLabel recentLabel = new GLabel(this.recentText);
        recentLabel.setLabelFor(this.recentSwatchPanel);
        JPanel recentPanel = new JPanel(new BorderLayout());
        recentPanel.add((Component)recentLabel, "North");
        recentPanel.add((Component)this.recentSwatchPanel, "Center");
        this.historySwatchPanel = new HistorySwatchPanel(this.historyColors);
        this.historySwatchPanel.addMouseListener(this.historySwatchListener);
        this.historySwatchListener = new HistorySwatchListener();
        this.historySwatchPanel.setBorder(border);
        JPanel historyPanel = new JPanel(new BorderLayout());
        GLabel historyLabel = new GLabel("History:");
        historyLabel.setLabelFor(this.historySwatchPanel);
        historyPanel.add((Component)historyLabel, "North");
        historyPanel.add((Component)this.historySwatchPanel, "Center");
        JPanel recentAndHistoryPanel = new JPanel((LayoutManager)new HorizontalLayout(10));
        recentAndHistoryPanel.add(recentPanel);
        recentAndHistoryPanel.add(historyPanel);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weighty = 0.0;
        superHolder.add(Box.createHorizontalStrut(10));
        gbc.gridx = 3;
        gbc.gridy = 0;
        superHolder.add((Component)recentAndHistoryPanel, gbc);
        JPanel colorValuePanel = this.createColorValuePanel();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 4;
        superHolder.add((Component)colorValuePanel, gbc);
        this.add(superHolder);
    }

    private JPanel createColorValuePanel() {
        JPanel colorValuePanel = new JPanel();
        colorValuePanel.setLayout(new BoxLayout(colorValuePanel, 2));
        JPanel colorTextPanel = new JPanel();
        colorTextPanel.setLayout(new BoxLayout(colorTextPanel, 3));
        this.colorNameField = new JTextField(20);
        this.colorNameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SettableColorSwatchChooserPanel.this.updateColorFromColorNameField();
                    e.consume();
                }
            }
        });
        Document document = this.colorNameField.getDocument();
        this.colorNameListener = new ColorNameListener();
        document.addDocumentListener(this.colorNameListener);
        GLabel colorNameLabel = new GLabel("Color Name: ");
        String colorNameTip = "Enter a Web Color name or a color value";
        this.colorValueLabel = new GDLabel();
        this.colorValueLabel.setForeground((Color)GThemeDefaults.Colors.Messages.HINT);
        this.colorValueLabel.setToolTipText("Double-click to copy color info");
        this.colorValueLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Color color = SettableColorSwatchChooserPanel.this.getColorFromModel();
                    String text = WebColors.toHexString((Color)color).toUpperCase() + "  " + WebColors.toRgbString((Color)color);
                    String colorName = WebColors.toColorName((Color)color);
                    if (colorName != null) {
                        text = text + "  " + colorName;
                    }
                    Clipboard systemClipboard = GClipboard.getSystemClipboard();
                    StringTransferable transferable = new StringTransferable(text);
                    systemClipboard.setContents(transferable, null);
                }
            }
        });
        this.colorValueLabel.setText("    ");
        ColorSelectionModel model = this.getColorSelectionModel();
        this.colorValueUpdateListener = e -> {
            Color color = this.getColorFromModel();
            this.recentSwatchPanel.setMostRecentColor(color);
            String text = WebColors.toHexString((Color)color) + "  " + WebColors.toRgbString((Color)color);
            String colorName = WebColors.toColorName((Color)color);
            this.colorValueLabel.setToolTipText(colorName);
            this.colorValueLabel.setText(text);
        };
        model.addChangeListener(this.colorValueUpdateListener);
        colorNameLabel.setToolTipText(colorNameTip);
        this.colorNameField.setToolTipText(colorNameTip);
        JPanel colorTextParentPanel = new JPanel();
        colorTextParentPanel.add(this.colorValueLabel);
        colorTextPanel.add(this.colorNameField);
        colorTextPanel.add(colorTextParentPanel);
        colorNameLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 5));
        colorNameLabel.setAlignmentY(0.0f);
        colorTextPanel.setAlignmentY(0.0f);
        colorValuePanel.add(colorNameLabel);
        colorValuePanel.add(colorTextPanel);
        colorValuePanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        return colorValuePanel;
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        ColorSelectionModel model = this.getColorSelectionModel();
        model.removeChangeListener(this.colorValueUpdateListener);
        super.uninstallChooserPanel(enclosingChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.recentSwatchPanel.removeMouseListener(this.recentSwatchListener);
        this.historySwatchPanel.removeMouseListener(this.historySwatchListener);
        this.colorNameField.getDocument().removeDocumentListener(this.colorNameListener);
        this.removeAll();
    }

    @Override
    public void updateChooser() {
    }

    private void updateColorFromColorNameField() {
        String text = this.colorNameField.getText();
        String colorText = text.replaceAll(" ", "");
        Color color = WebColors.getColor((String)colorText);
        if (color == null) {
            color = WebColors.getColor((String)("#" + colorText));
        }
        if (color != null) {
            this.getColorSelectionModel().setSelectedColor(color);
        }
    }

    private class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        private MainSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = SettableColorSwatchChooserPanel.this.swatchPanel.getColorForLocation(e.getX(), e.getY());
            SettableColorSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }

    private class RecentSwatchListener
    extends MouseAdapter {
        private RecentSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = SettableColorSwatchChooserPanel.this.recentSwatchPanel.getColorForLocation(e.getX(), e.getY());
            SettableColorSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }

    private class HistorySwatchListener
    extends MouseAdapter {
        private HistorySwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = SettableColorSwatchChooserPanel.this.historySwatchPanel.getColorForLocation(e.getX(), e.getY());
            SettableColorSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }

    private class ColorNameListener
    implements DocumentListener {
        private ColorNameListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SettableColorSwatchChooserPanel.this.updateColorFromColorNameField();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SettableColorSwatchChooserPanel.this.updateColorFromColorNameField();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SettableColorSwatchChooserPanel.this.updateColorFromColorNameField();
        }
    }
}

