/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.options.editor.CustomOptionComponent;
import docking.options.editor.DefaultOptionComponent;
import ghidra.framework.options.EditorState;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JPanel;

public abstract class GenericOptionsComponent
extends JPanel {
    protected GenericOptionsComponent() {
    }

    public static GenericOptionsComponent createOptionComponent(EditorState state) {
        if (state.supportsCustomOptionsEditor()) {
            return new CustomOptionComponent(state);
        }
        return new DefaultOptionComponent(state);
    }

    public static void alignLabels(List<GenericOptionsComponent> components) {
        int maxWidth = 0;
        int maxHeight = 0;
        for (GenericOptionsComponent optionComponent : components) {
            Dimension dimension = optionComponent.getPreferredAlignmentSize();
            maxWidth = Math.max(dimension.width, maxWidth);
            maxHeight = Math.max(dimension.height, maxHeight);
        }
        for (GenericOptionsComponent component : components) {
            component.setPreferredAlignmentSize(new Dimension(maxWidth, maxHeight));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    protected void setPreferredAlignmentSize(Dimension dimension) {
    }

    protected Dimension getPreferredAlignmentSize() {
        return this.getPreferredSize();
    }
}

