/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.functiongraph.actions;

import docking.ActionContext;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.features.codecompare.functiongraph.FgComparisonContext;
import ghidra.features.codecompare.functiongraph.FgDisplay;
import ghidra.features.codecompare.functiongraph.FunctionGraphCodeComparisonView;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.Duo;

public class FgTogglePopupsAction
extends ToggleDockingAction {
    private FunctionGraphCodeComparisonView fgProvider;

    public FgTogglePopupsAction(FunctionGraphCodeComparisonView fgProvider) {
        super("Display Popup Windows", fgProvider.getOwner());
        this.fgProvider = fgProvider;
        this.setPopupMenuData(new MenuData(new String[]{"Display Popup Windows"}));
        this.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Popups"));
    }

    public void actionPerformed(ActionContext context) {
        Duo<FgDisplay> displays = this.fgProvider.getDisplays();
        FgDisplay leftDisplay = (FgDisplay)displays.get(Duo.Side.LEFT);
        FGController controller = leftDisplay.getController();
        boolean visible = this.isSelected();
        controller.setPopupsVisible(visible);
        FgDisplay rightDisplay = (FgDisplay)displays.get(Duo.Side.RIGHT);
        FGController rightController = rightDisplay.getController();
        rightController.setPopupsVisible(visible);
        this.fgProvider.stateChanged();
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof FgComparisonContext)) {
            return false;
        }
        Duo<FgDisplay> displays = this.fgProvider.getDisplays();
        FgDisplay leftDisplay = (FgDisplay)displays.get(Duo.Side.LEFT);
        FGController controller = leftDisplay.getController();
        return controller.hasResults();
    }
}

