/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.func;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.GlobalNamespace;
import ghidra.program.model.data.ISF.IsfObject;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import sarif.export.func.ExtFunctionParam;
import sarif.export.func.ExtFunctionRegVar;
import sarif.export.func.ExtFunctionStack;

public class ExtFunction
implements IsfObject {
    String name;
    String namespace;
    boolean namespaceIsClass;
    String location;
    String comment;
    String repeatableComment;
    String value;
    String callingConvention;
    String callFixup;
    String signatureSource;
    String sourceType;
    boolean hasVarArgs;
    boolean isInline;
    boolean hasNoReturn;
    boolean hasCustomStorage;
    boolean isStackPurgeSizeValid;
    boolean isLibrary;
    boolean isGlobal;
    boolean isExternal;
    boolean isThunk;
    String thunkAddress;
    ExtFunctionStack stack;
    List<ExtFunctionRegVar> regVars = new ArrayList<ExtFunctionRegVar>();
    ExtFunctionParam ret;
    List<ExtFunctionParam> params = new ArrayList<ExtFunctionParam>();

    public ExtFunction(Function func, TaskMonitor monitor) {
        Parameter[] fnParams;
        Namespace ns;
        this.name = func.getName(true);
        this.location = func.getEntryPoint().toString();
        this.comment = func.getComment();
        this.repeatableComment = func.getRepeatableComment();
        this.signatureSource = func.getSignatureSource().toString();
        SourceType srcType = func.getSymbol().getSource();
        this.sourceType = srcType.toString();
        if (srcType != SourceType.DEFAULT) {
            this.name = func.getName();
        }
        if (!((ns = func.getParentNamespace()) instanceof GlobalNamespace)) {
            this.namespace = ns.getName(true);
            if (ns instanceof GhidraClass) {
                this.namespaceIsClass = true;
            }
        }
        if (func.getSignatureSource() != SourceType.DEFAULT) {
            this.value = func.getPrototypeString(true, true);
        }
        this.callingConvention = func.getCallingConventionName();
        this.callFixup = func.getCallFixup();
        this.hasVarArgs = func.hasVarArgs();
        this.isInline = func.isInline();
        this.hasNoReturn = func.hasNoReturn();
        this.hasCustomStorage = func.hasCustomVariableStorage();
        this.isStackPurgeSizeValid = func.isStackPurgeSizeValid();
        this.isLibrary = func.isLibrary();
        this.isGlobal = func.isGlobal();
        this.isExternal = func.isExternal();
        this.isThunk = func.isThunk();
        if (func.isThunk()) {
            Address thunkAddr = func.getThunkedFunction(false).getEntryPoint();
            this.thunkAddress = thunkAddr.toString();
        }
        this.stack = new ExtFunctionStack(func.getStackFrame(), this.hasCustomStorage);
        if (func.isStackPurgeSizeValid()) {
            this.stack.setPurgeSize(func.getStackPurgeSize());
        }
        Parameter rp = func.getReturn();
        this.ret = new ExtFunctionParam(rp);
        for (Parameter param : fnParams = func.getParameters()) {
            if (param.isRegisterVariable()) {
                this.regVars.add(new ExtFunctionRegVar(param));
            }
            this.params.add(new ExtFunctionParam(param));
        }
    }
}

