/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.extlib;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalLocationIterator;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.extlib.ExtLibrary;
import sarif.export.extlib.ExtLibraryLocation;
import sarif.managers.ExternalLibSarifMgr;

public class SarifExternalLibraryWriter
extends AbstractExtWriter {
    private List<String> externalNames = new ArrayList<String>();
    private ExternalManager externalManager;

    public SarifExternalLibraryWriter(ExternalManager externalManager, List<String> request, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.externalManager = externalManager;
        this.externalNames = request;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genLibraries(monitor);
        this.root.add("definedData", (JsonElement)this.objects);
    }

    private void genLibraries(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.externalNames.size());
        for (String n : this.externalNames) {
            String path = this.externalManager.getExternalLibraryPath(n);
            if (path == null) {
                path = "";
            }
            ExtLibrary lib = new ExtLibrary(n, path, SourceType.DEFAULT);
            SarifObject sarif = new SarifObject(ExternalLibSarifMgr.SUBKEY0, ExternalLibSarifMgr.KEY, this.getTree(lib), null);
            this.objects.add(this.getTree(sarif));
            ExternalLocationIterator externalLocations = this.externalManager.getExternalLocations(n);
            while (externalLocations.hasNext()) {
                ExternalLocation loc = externalLocations.next();
                ExtLibraryLocation obj = new ExtLibraryLocation(loc);
                SarifObject sarif2 = new SarifObject(ExternalLibSarifMgr.SUBKEY1, ExternalLibSarifMgr.KEY, this.getTree(obj), loc.getAddress(), loc.getAddress());
                this.objects.add(this.getTree(sarif2));
            }
            monitor.increment();
        }
    }

    public JsonArray getResults() {
        return this.objects;
    }
}

