/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.separator;

import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class TitledSeparator
extends JPanel {
    private Font m_title_font;
    private Color m_title_color;
    private JLabel m_label;

    public TitledSeparator() {
        this("Title", 2);
    }

    public TitledSeparator(String string) {
        this(string, 2);
    }

    public TitledSeparator(String string, int n) {
        this.setLayout(new TitledSeparatorLayout());
        this.m_label = string == null ? new TitleLabel() : new TitleLabel(string);
        this.m_label.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.m_label.setFont(UIManager.getFont("TitledBorder.font"));
        this.m_label.setVerticalAlignment(0);
        this.m_label.setHorizontalAlignment(n);
        this.createSeparator(this.m_label);
    }

    private void createSeparator(JLabel jLabel) {
        this.removeAll();
        this.setOpaque(false);
        this.add(jLabel);
        this.add(new JSeparator());
        if (jLabel != null && jLabel.getHorizontalAlignment() == 0) {
            this.add(new JSeparator());
        }
    }

    public int getAlignment() {
        return this.m_label.getHorizontalAlignment();
    }

    public Color getTitleColor() {
        return this.m_title_color == null ? UIManager.getColor("TitledBorder.titleColor") : this.m_title_color;
    }

    public Font getTitleFont() {
        return this.m_title_font == null ? UIManager.getFont("TitledBorder.font") : this.m_title_font;
    }

    public String getText() {
        return this.m_label.getText();
    }

    public void setAlignment(int n) {
        if (this.m_label.getHorizontalAlignment() == n) {
            return;
        }
        this.m_label.setHorizontalAlignment(n);
        this.createSeparator(this.m_label);
    }

    public void setTitleColor(Color color) {
        this.m_title_color = color;
        if (this.m_label != null) {
            this.m_label.setForeground(color);
        }
    }

    public void setTitleFont(Font font) {
        this.m_title_font = font;
        if (this.m_label != null) {
            this.m_label.setFont(font);
        }
    }

    public void setText(String string) {
        this.m_label.setText(string);
    }

    private class TitledSeparatorLayout
    implements LayoutManager {
        private TitledSeparatorLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            JLabel jLabel = this.getLabel(container);
            Dimension dimension = ((Component)jLabel).getPreferredSize();
            Insets insets = container.getInsets();
            int n = Math.max(1, dimension.width + insets.left + insets.right);
            int n2 = Math.max(1, dimension.height + insets.top + insets.bottom);
            return new Dimension(n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension = container.getSize();
                Insets insets = container.getInsets();
                int n = dimension.width - insets.left - insets.right;
                JLabel jLabel = this.getLabel(container);
                Dimension dimension2 = jLabel.getPreferredSize();
                int n2 = dimension2.width;
                int n3 = dimension2.height;
                Component component = container.getComponent(1);
                int n4 = component.getPreferredSize().height;
                FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
                int n5 = fontMetrics.getMaxAscent();
                int n6 = 3;
                int n7 = Sizes.dialogUnitXAsPixel(n6, jLabel);
                int n8 = 1 + (n3 - n4) / 2;
                int n9 = jLabel.getHorizontalAlignment();
                int n10 = insets.top;
                if (n9 == 2) {
                    int n11 = insets.left;
                    jLabel.setBounds(n11, n10, n2, n3);
                    n11 += n2;
                    int n12 = dimension.width - insets.right - (n11 += n7);
                    component.setBounds(n11, n10 + n8, n12, n4);
                } else if (n9 == 4) {
                    int n13 = insets.left + n - n2;
                    jLabel.setBounds(n13, n10, n2, n3);
                    n13 -= n7;
                    int n14 = --n13 - insets.left;
                    component.setBounds(insets.left, n10 + n8, n14, n4);
                } else {
                    int n15 = (n - n2 - 2 * n7) / 2;
                    int n16 = insets.left;
                    component.setBounds(n16, n10 + n8, n15 - 1, n4);
                    n16 += n15;
                    jLabel.setBounds(n16 += n7, n10, n2, n3);
                    n16 += n2;
                    Component component2 = container.getComponent(2);
                    int n17 = dimension.width - insets.right - (n16 += n7);
                    component2.setBounds(n16, n10 + n8, n17, n4);
                }
            }
        }

        private JLabel getLabel(Container container) {
            return TitledSeparator.this.m_label;
        }
    }

    private class TitleLabel
    extends JLabel {
        private TitleLabel() {
        }

        private TitleLabel(String string) {
            super(string);
        }

        public void updateUI() {
            super.updateUI();
            if (TitledSeparator.this.m_label != null) {
                TitledSeparator.this.m_label.setForeground(TitledSeparator.this.getTitleColor());
                TitledSeparator.this.m_label.setFont(TitledSeparator.this.getTitleFont());
            }
        }
    }
}

