/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import ghidra.util.LockHold;
import ghidra.util.database.DBSynchronizedIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;

public class DBSynchronizedCollection<E>
implements Collection<E> {
    private final Collection<E> delegate;
    private final ReadWriteLock lock;

    public DBSynchronizedCollection(Collection<E> delegate, ReadWriteLock lock) {
        this.delegate = delegate;
        this.lock = lock;
    }

    @Override
    public int size() {
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            int n = this.delegate.size();
            return n;
        }
    }

    @Override
    public boolean isEmpty() {
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
    }

    @Override
    public boolean contains(Object o) {
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            boolean bl = this.delegate.contains(o);
            return bl;
        }
    }

    @Override
    public Iterator<E> iterator() {
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            DBSynchronizedIterator<E> dBSynchronizedIterator = new DBSynchronizedIterator<E>(this.delegate.iterator(), this.lock);
            return dBSynchronizedIterator;
        }
    }

    @Override
    public Object[] toArray() {
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            Object[] objectArray = this.delegate.toArray();
            return objectArray;
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            T[] TArray = this.delegate.toArray(a);
            return TArray;
        }
    }

    @Override
    public boolean add(E e) {
        try (LockHold hold = LockHold.lock(this.lock.writeLock());){
            boolean bl = this.delegate.add(e);
            return bl;
        }
    }

    @Override
    public boolean remove(Object o) {
        try (LockHold hold = LockHold.lock(this.lock.writeLock());){
            boolean bl = this.delegate.remove(o);
            return bl;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            boolean bl = this.delegate.containsAll(c);
            return bl;
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        try (LockHold hold = LockHold.lock(this.lock.writeLock());){
            boolean bl = this.delegate.addAll(c);
            return bl;
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        try (LockHold hold = LockHold.lock(this.lock.writeLock());){
            boolean bl = this.delegate.removeAll(c);
            return bl;
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        try (LockHold hold = LockHold.lock(this.lock.writeLock());){
            boolean bl = this.delegate.retainAll(c);
            return bl;
        }
    }

    @Override
    public void clear() {
        try (LockHold hold = LockHold.lock(this.lock.writeLock());){
            this.delegate.clear();
        }
    }
}

