/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.DynamicColumnTableModel;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableHeaderRenderer;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.SpannedRenderer;
import generic.Span;
import ghidra.util.datastruct.ListenerSet;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.function.Consumer;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class RangeCursorTableHeaderRenderer<N extends Number>
extends GTableHeaderRenderer
implements SpannedRenderer<N> {
    protected static final int ARROW_SIZE = 10;
    protected static final Polygon ARROW = new Polygon(new int[]{0, -10, -10}, new int[]{0, 10, -10}, 3);
    protected SpannedRenderer.DoubleSpan fullRangeDouble = new SpannedRenderer.DoubleSpan(0.0, 1.0);
    protected double span = 1.0;
    protected Span<N, ?> fullRange;
    protected N pos;
    protected final DynamicTableColumn<?, ?, ?> col;
    protected double doublePos;
    private JTable savedTable;
    private int savedViewColumn;
    private final ForSeekMouseListener forSeekMouseListener = new ForSeekMouseListener();
    private final ListenerSet<SeekListener> listeners = new ListenerSet(SeekListener.class, true);

    public RangeCursorTableHeaderRenderer(N pos, DynamicTableColumn<?, ?, ?> col) {
        this.pos = pos;
        this.col = col;
    }

    @Override
    public void setFullRange(Span<N, ?> fullRange) {
        this.fullRangeDouble = SpannedRenderer.validateViewRange(fullRange);
        this.span = this.fullRangeDouble.max() - this.fullRangeDouble.min();
    }

    public void setCursorPosition(N pos) {
        this.pos = pos;
        this.doublePos = ((Number)pos).doubleValue();
    }

    protected void setSavedTable(JTable table) {
        JTableHeader header;
        if (this.savedTable == table) {
            return;
        }
        if (this.savedTable != null) {
            header = this.savedTable.getTableHeader();
            header.removeMouseListener(this.forSeekMouseListener);
            header.removeMouseMotionListener(this.forSeekMouseListener);
        }
        this.savedTable = table;
        if (this.savedTable != null) {
            header = this.savedTable.getTableHeader();
            MouseListener[] curMouseListeners = header.getMouseListeners();
            MouseMotionListener[] curMotionListeners = header.getMouseMotionListeners();
            for (MouseListener mouseListener : curMouseListeners) {
                header.removeMouseListener(mouseListener);
            }
            for (EventListener eventListener : curMotionListeners) {
                header.removeMouseMotionListener((MouseMotionListener)eventListener);
            }
            header.addMouseListener(this.forSeekMouseListener);
            header.addMouseMotionListener(this.forSeekMouseListener);
            for (EventListener eventListener : curMouseListeners) {
                header.addMouseListener((MouseListener)eventListener);
            }
            for (EventListener eventListener : curMotionListeners) {
                header.addMouseMotionListener((MouseMotionListener)eventListener);
            }
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setSavedTable(table);
        this.savedViewColumn = column;
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.paintCursor(g);
    }

    protected void paintCursor(Graphics parentG) {
        Graphics2D g = (Graphics2D)parentG.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double x = (this.doublePos - this.fullRangeDouble.min()) / this.span * (double)this.getWidth();
        g.translate(x, (double)this.getHeight());
        g.rotate(1.5707963267948966);
        g.setColor(this.getForeground());
        g.fillPolygon(ARROW);
    }

    public void addSeekListener(SeekListener listener) {
        this.listeners.add((Object)listener);
    }

    public N getCursorPosition() {
        return this.pos;
    }

    @Override
    public Span<N, ?> getFullRange() {
        return this.fullRange;
    }

    public SpannedRenderer.DoubleSpan getFullRangeDouble() {
        return this.fullRangeDouble;
    }

    @Override
    public double getSpan() {
        return this.span;
    }

    protected class ForSeekMouseListener
    extends MouseAdapter {
        protected ForSeekMouseListener() {
        }

        private boolean checkRemove() {
            if (RangeCursorTableHeaderRenderer.this.savedTable == null) {
                return false;
            }
            TableModel unwrapped = RowObjectTableModel.unwrap((TableModel)RangeCursorTableHeaderRenderer.this.savedTable.getModel());
            if (!(unwrapped instanceof DynamicColumnTableModel)) {
                RangeCursorTableHeaderRenderer.this.setSavedTable(null);
                return true;
            }
            DynamicColumnTableModel model = (DynamicColumnTableModel)unwrapped;
            int count = RangeCursorTableHeaderRenderer.this.savedTable.getColumnCount();
            for (int i = 0; i < count; ++i) {
                int j = RangeCursorTableHeaderRenderer.this.savedTable.convertColumnIndexToModel(i);
                if (model.getColumn(j) != RangeCursorTableHeaderRenderer.this.col) continue;
                return false;
            }
            RangeCursorTableHeaderRenderer.this.setSavedTable(null);
            return true;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.checkRemove()) {
                return;
            }
            if ((e.getModifiersEx() & 0x40) != 0) {
                return;
            }
            if (e.getButton() != 1) {
                return;
            }
            this.doSeek(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.checkRemove()) {
                return;
            }
            int onmask = 1024;
            int offmask = 64;
            if ((e.getModifiersEx() & (onmask | offmask)) != onmask) {
                return;
            }
            this.doSeek(e);
        }

        protected void doSeek(MouseEvent e) {
            TableColumnModel colModel = RangeCursorTableHeaderRenderer.this.savedTable.getColumnModel();
            JTableHeader header = RangeCursorTableHeaderRenderer.this.savedTable.getTableHeader();
            TableColumn myViewCol = colModel.getColumn(RangeCursorTableHeaderRenderer.this.savedViewColumn);
            if (header.getResizingColumn() != null) {
                return;
            }
            int clickedViewColIdx = colModel.getColumnIndexAtX(e.getX());
            if (clickedViewColIdx != RangeCursorTableHeaderRenderer.this.savedViewColumn) {
                return;
            }
            TableColumn draggedViewCol = header.getDraggedColumn();
            if (draggedViewCol == myViewCol) {
                header.setDraggedColumn(null);
            } else if (draggedViewCol != null) {
                return;
            }
            int colX = 0;
            for (int i = 0; i < clickedViewColIdx; ++i) {
                colX += colModel.getColumn(i).getWidth();
            }
            double pos = RangeCursorTableHeaderRenderer.this.span * (double)(e.getX() - colX) / (double)myViewCol.getWidth() + RangeCursorTableHeaderRenderer.this.fullRangeDouble.min();
            e.consume();
            ((SeekListener)RangeCursorTableHeaderRenderer.this.listeners.invoke()).accept(pos);
        }
    }

    public static interface SeekListener
    extends Consumer<Double> {
    }
}

