/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.remote;

import ghidra.framework.remote.RemoteRepositoryHandle;
import ghidra.framework.remote.RemoteRepositoryServerHandle;
import ghidra.server.Repository;
import ghidra.server.RepositoryManager;
import ghidra.server.remote.GhidraServer;
import ghidra.server.remote.RepositoryHandleImpl;
import ghidra.server.remote.ServerPortFactory;
import ghidra.util.exception.UserAccessException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class RepositoryServerHandleImpl
extends UnicastRemoteObject
implements RemoteRepositoryServerHandle {
    private final String currentUser;
    private final RepositoryManager mgr;
    private final boolean supportPasswordChange;
    private final boolean readOnly;

    public boolean anonymousAccessAllowed() {
        return this.mgr.anonymousAccessAllowed();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public RepositoryServerHandleImpl(String user, boolean readOnly, RepositoryManager mgr, boolean supportPasswordChange) throws RemoteException {
        super(ServerPortFactory.getRMISSLPort(), GhidraServer.getRMIClientSocketFactory(), GhidraServer.getRMIServerSocketFactory());
        this.currentUser = user;
        this.readOnly = readOnly;
        this.mgr = mgr;
        this.supportPasswordChange = supportPasswordChange;
        mgr.addHandle(this);
    }

    public void unreferenced() {
        this.mgr.dropHandle(this);
    }

    public RemoteRepositoryHandle createRepository(String name) throws IOException {
        Repository repository = this.mgr.createRepository(this.currentUser, name);
        return new RepositoryHandleImpl(this.currentUser, repository);
    }

    public RemoteRepositoryHandle getRepository(String name) throws IOException {
        System.gc();
        Repository repository = this.mgr.getRepository(this.currentUser, name);
        if (repository == null) {
            return null;
        }
        return new RepositoryHandleImpl(this.currentUser, repository);
    }

    public void deleteRepository(String name) throws UserAccessException, IOException {
        this.mgr.deleteRepository(this.currentUser, name);
    }

    public String[] getRepositoryNames() {
        return this.mgr.getRepositoryNames(this.currentUser);
    }

    public String getUser() throws IOException {
        return this.currentUser;
    }

    public String[] getAllUsers() throws IOException {
        if (this.readOnly) {
            return new String[0];
        }
        return this.mgr.getAllUsers(this.currentUser);
    }

    public boolean canSetPassword() throws RemoteException {
        return this.supportPasswordChange && this.mgr.getUserManager().canSetPassword(this.currentUser);
    }

    public long getPasswordExpiration() throws IOException {
        if (this.canSetPassword()) {
            return this.mgr.getUserManager().getPasswordExpiration(this.currentUser);
        }
        return -1L;
    }

    public boolean setPassword(char[] saltedSHA256PasswordHash) throws IOException {
        if (!this.canSetPassword()) {
            return false;
        }
        return this.mgr.getUserManager().setPassword(this.currentUser, saltedSHA256PasswordHash, false);
    }

    public void connected() {
    }
}

