/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractBlockMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractDataMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractDefinedSingleAddressRangeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractLabelMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractLocalSymbolInOptimizedCodeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractManagedProcedureMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractManagedSymbolWithSlotIndexFieldMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractProcedureMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractPublicMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractReferenceMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractRegisterRelativeAddressMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractUserDefinedTypeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractUsingNamespaceMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractWithMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.EndMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ExtraFrameAndProcedureInformationMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.OemDefinedMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.PeCoffGroupMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.PeCoffSectionMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ProcedureIdEndMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.SeparatedCodeFromCompilerSupportMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.TrampolineMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.BlockSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.DataSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DefinedSingleAddressRangeSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.EndSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.FrameAndProcedureInformationSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.FunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.LabelSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.LocalOptimizedSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.ManagedProcedureSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.ManagedSymbolWithSlotSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NoSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.OemDefinedSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.PeCoffGroupSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.PeCoffSectionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.ProcedureIdEndSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.PublicSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.ReferenceSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.RegisterRelativeSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.SeparatedCodeSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.TrampolineSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.TypedefSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.UsingNamespaceSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.WithSymbolApplier;

public class SymbolApplierFactory {
    private DefaultPdbApplicator applicator;

    SymbolApplierFactory(DefaultPdbApplicator applicator) {
        this.applicator = applicator;
    }

    MsSymbolApplier getSymbolApplier(MsSymbolIterator iter) {
        AbstractMsSymbol symbol = iter.peek();
        if (symbol == null) {
            this.applicator.appendLogMsg("PDB Warning: No AbstractMsSymbol");
            return null;
        }
        return this.getSymbolApplier(symbol, iter);
    }

    MsSymbolApplier getSymbolApplier(AbstractMsSymbol symbol, MsSymbolIterator iter) {
        MsSymbolApplier applier = this.getSymbolApplierInternal(symbol, iter);
        if (applier instanceof NoSymbolApplier) {
            this.applicator.getPdbApplicatorMetrics().witnessCannotApplySymbolType(symbol);
        }
        return applier;
    }

    private MsSymbolApplier getSymbolApplierInternal(AbstractMsSymbol symbol, MsSymbolIterator iter) {
        MsSymbolApplier applier = null;
        int pdbId = symbol.getPdbId();
        switch (pdbId) {
            case 4: {
                applier = new TypedefSymbolApplier(this.applicator, (AbstractUserDefinedTypeMsSymbol)symbol);
                break;
            }
            case 6: {
                applier = new EndSymbolApplier(this.applicator, (EndMsSymbol)symbol);
                break;
            }
            case 11: {
                applier = new TypedefSymbolApplier(this.applicator, (AbstractUserDefinedTypeMsSymbol)symbol);
                break;
            }
            case 257: {
                applier = new DataSymbolApplier(this.applicator, (AbstractDataMsSymbol)symbol);
                break;
            }
            case 258: {
                applier = new DataSymbolApplier(this.applicator, (AbstractDataMsSymbol)symbol);
                break;
            }
            case 259: {
                applier = new PublicSymbolApplier(this.applicator, (AbstractPublicMsSymbol)symbol);
                break;
            }
            case 260: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 261: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 262: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 263: {
                applier = new BlockSymbolApplier(this.applicator, (AbstractBlockMsSymbol)symbol);
                break;
            }
            case 264: {
                applier = new WithSymbolApplier(this.applicator, (AbstractWithMsSymbol)symbol);
                break;
            }
            case 265: {
                applier = new LabelSymbolApplier(this.applicator, (AbstractLabelMsSymbol)symbol);
                break;
            }
            case 268: {
                applier = new RegisterRelativeSymbolApplier(this.applicator, (AbstractRegisterRelativeAddressMsSymbol)symbol);
                break;
            }
            case 513: {
                applier = new DataSymbolApplier(this.applicator, (AbstractDataMsSymbol)symbol);
                break;
            }
            case 514: {
                applier = new DataSymbolApplier(this.applicator, (AbstractDataMsSymbol)symbol);
                break;
            }
            case 515: {
                applier = new PublicSymbolApplier(this.applicator, (AbstractPublicMsSymbol)symbol);
                break;
            }
            case 516: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 517: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 518: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 519: {
                applier = new BlockSymbolApplier(this.applicator, (AbstractBlockMsSymbol)symbol);
                break;
            }
            case 520: {
                applier = new WithSymbolApplier(this.applicator, (AbstractWithMsSymbol)symbol);
                break;
            }
            case 521: {
                applier = new LabelSymbolApplier(this.applicator, (AbstractLabelMsSymbol)symbol);
                break;
            }
            case 524: {
                applier = new RegisterRelativeSymbolApplier(this.applicator, (AbstractRegisterRelativeAddressMsSymbol)symbol);
                break;
            }
            case 768: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 769: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 1024: {
                applier = new ReferenceSymbolApplier(this.applicator, (AbstractReferenceMsSymbol)symbol);
                break;
            }
            case 1025: {
                applier = new ReferenceSymbolApplier(this.applicator, (AbstractReferenceMsSymbol)symbol);
                break;
            }
            case 1027: {
                applier = new ReferenceSymbolApplier(this.applicator, (AbstractReferenceMsSymbol)symbol);
                break;
            }
            case 1028: {
                applier = new OemDefinedSymbolApplier(this.applicator, (OemDefinedMsSymbol)symbol);
                break;
            }
            case 4099: {
                applier = new TypedefSymbolApplier(this.applicator, (AbstractUserDefinedTypeMsSymbol)symbol);
                break;
            }
            case 4100: {
                applier = new TypedefSymbolApplier(this.applicator, (AbstractUserDefinedTypeMsSymbol)symbol);
                break;
            }
            case 4103: {
                applier = new DataSymbolApplier(this.applicator, (AbstractDataMsSymbol)symbol);
                break;
            }
            case 4104: {
                applier = new DataSymbolApplier(this.applicator, (AbstractDataMsSymbol)symbol);
                break;
            }
            case 4105: {
                applier = new PublicSymbolApplier(this.applicator, (AbstractPublicMsSymbol)symbol);
                break;
            }
            case 4106: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4107: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4109: {
                applier = new RegisterRelativeSymbolApplier(this.applicator, (AbstractRegisterRelativeAddressMsSymbol)symbol);
                break;
            }
            case 4112: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4113: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4114: {
                applier = new FrameAndProcedureInformationSymbolApplier(this.applicator, (ExtraFrameAndProcedureInformationMsSymbol)symbol);
                break;
            }
            case 4117: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4118: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4122: {
                applier = new ManagedProcedureSymbolApplier(this.applicator, (AbstractManagedProcedureMsSymbol)symbol);
                break;
            }
            case 4123: {
                applier = new ManagedProcedureSymbolApplier(this.applicator, (AbstractManagedProcedureMsSymbol)symbol);
                break;
            }
            case 4128: {
                applier = new DataSymbolApplier(this.applicator, (AbstractDataMsSymbol)symbol);
                break;
            }
            case 4129: {
                applier = new DataSymbolApplier(this.applicator, (AbstractDataMsSymbol)symbol);
                break;
            }
            case 4132: {
                applier = new ManagedSymbolWithSlotSymbolApplier(this.applicator, (AbstractManagedSymbolWithSlotIndexFieldMsSymbol)symbol);
                break;
            }
            case 4137: {
                applier = new UsingNamespaceSymbolApplier(this.applicator, (AbstractUsingNamespaceMsSymbol)symbol);
                break;
            }
            case 4354: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4355: {
                applier = new BlockSymbolApplier(this.applicator, (AbstractBlockMsSymbol)symbol);
                break;
            }
            case 4356: {
                applier = new WithSymbolApplier(this.applicator, (AbstractWithMsSymbol)symbol);
                break;
            }
            case 4357: {
                applier = new LabelSymbolApplier(this.applicator, (AbstractLabelMsSymbol)symbol);
                break;
            }
            case 4360: {
                applier = new TypedefSymbolApplier(this.applicator, (AbstractUserDefinedTypeMsSymbol)symbol);
                break;
            }
            case 4361: {
                applier = new TypedefSymbolApplier(this.applicator, (AbstractUserDefinedTypeMsSymbol)symbol);
                break;
            }
            case 4364: {
                applier = new DataSymbolApplier(this.applicator, (AbstractDataMsSymbol)symbol);
                break;
            }
            case 4365: {
                applier = new DataSymbolApplier(this.applicator, (AbstractDataMsSymbol)symbol);
                break;
            }
            case 4366: {
                applier = new PublicSymbolApplier(this.applicator, (AbstractPublicMsSymbol)symbol);
                break;
            }
            case 4367: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4368: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4369: {
                applier = new RegisterRelativeSymbolApplier(this.applicator, (AbstractRegisterRelativeAddressMsSymbol)symbol);
                break;
            }
            case 4372: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4373: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4376: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4377: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4380: {
                applier = new DataSymbolApplier(this.applicator, (AbstractDataMsSymbol)symbol);
                break;
            }
            case 4381: {
                applier = new DataSymbolApplier(this.applicator, (AbstractDataMsSymbol)symbol);
                break;
            }
            case 4384: {
                applier = new ManagedSymbolWithSlotSymbolApplier(this.applicator, (AbstractManagedSymbolWithSlotIndexFieldMsSymbol)symbol);
                break;
            }
            case 4388: {
                applier = new UsingNamespaceSymbolApplier(this.applicator, (AbstractUsingNamespaceMsSymbol)symbol);
                break;
            }
            case 4389: {
                applier = new ReferenceSymbolApplier(this.applicator, (AbstractReferenceMsSymbol)symbol);
                break;
            }
            case 4390: {
                applier = new ReferenceSymbolApplier(this.applicator, (AbstractReferenceMsSymbol)symbol);
                break;
            }
            case 4391: {
                applier = new ReferenceSymbolApplier(this.applicator, (AbstractReferenceMsSymbol)symbol);
                break;
            }
            case 4392: {
                applier = new ReferenceSymbolApplier(this.applicator, (AbstractReferenceMsSymbol)symbol);
                break;
            }
            case 4393: {
                applier = new ReferenceSymbolApplier(this.applicator, (AbstractReferenceMsSymbol)symbol);
                break;
            }
            case 4394: {
                applier = new ManagedProcedureSymbolApplier(this.applicator, (AbstractManagedProcedureMsSymbol)symbol);
                break;
            }
            case 4395: {
                applier = new ManagedProcedureSymbolApplier(this.applicator, (AbstractManagedProcedureMsSymbol)symbol);
                break;
            }
            case 4396: {
                applier = new TrampolineSymbolApplier(this.applicator, (TrampolineMsSymbol)symbol);
                break;
            }
            case 4402: {
                applier = new SeparatedCodeSymbolApplier(this.applicator, (SeparatedCodeFromCompilerSupportMsSymbol)symbol);
                break;
            }
            case 4403: {
                applier = new LocalOptimizedSymbolApplier(this.applicator, (AbstractLocalSymbolInOptimizedCodeMsSymbol)symbol);
                break;
            }
            case 4406: {
                applier = new PeCoffSectionSymbolApplier(this.applicator, (PeCoffSectionMsSymbol)symbol);
                break;
            }
            case 4407: {
                applier = new PeCoffGroupSymbolApplier(this.applicator, (PeCoffGroupMsSymbol)symbol);
                break;
            }
            case 4414: {
                applier = new LocalOptimizedSymbolApplier(this.applicator, (AbstractLocalSymbolInOptimizedCodeMsSymbol)symbol);
                break;
            }
            case 4415: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, (AbstractDefinedSingleAddressRangeMsSymbol)symbol);
                break;
            }
            case 4416: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, (AbstractDefinedSingleAddressRangeMsSymbol)symbol);
                break;
            }
            case 4417: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, (AbstractDefinedSingleAddressRangeMsSymbol)symbol);
                break;
            }
            case 4418: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, (AbstractDefinedSingleAddressRangeMsSymbol)symbol);
                break;
            }
            case 4419: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, (AbstractDefinedSingleAddressRangeMsSymbol)symbol);
                break;
            }
            case 4420: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, (AbstractDefinedSingleAddressRangeMsSymbol)symbol);
                break;
            }
            case 4421: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, (AbstractDefinedSingleAddressRangeMsSymbol)symbol);
                break;
            }
            case 4422: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4423: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4424: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4425: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4426: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4427: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4431: {
                applier = new ProcedureIdEndSymbolApplier(this.applicator, (ProcedureIdEndMsSymbol)symbol);
                break;
            }
            case 4432: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, (AbstractDefinedSingleAddressRangeMsSymbol)symbol);
                break;
            }
            case 4437: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4438: {
                applier = new FunctionSymbolApplier(this.applicator, (AbstractProcedureMsSymbol)symbol);
                break;
            }
            case 4439: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, (AbstractDefinedSingleAddressRangeMsSymbol)symbol);
                break;
            }
            default: {
                applier = new NoSymbolApplier(this.applicator, symbol);
            }
        }
        return applier;
    }
}

