/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractRegisterRelativeAddressMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NestableSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NestingSymbolApplier;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.Objects;

public class RegisterRelativeSymbolApplier
extends MsSymbolApplier
implements NestableSymbolApplier {
    private AbstractRegisterRelativeAddressMsSymbol symbol;

    public RegisterRelativeSymbolApplier(DefaultPdbApplicator applicator, AbstractRegisterRelativeAddressMsSymbol symbol) {
        super(applicator);
        this.symbol = symbol;
    }

    private boolean createFunctionVariable(FunctionSymbolApplier applier, AbstractRegisterRelativeAddressMsSymbol symbol) throws CancelledException, PdbException {
        Register sp;
        Objects.requireNonNull(applier, "FunctionSymbolApplier cannot be null");
        Function function = applier.getFunction();
        if (function == null) {
            this.applicator.appendLogMsg("Could not create stack variable for non-existent function.");
            return false;
        }
        String registerName = symbol.getRegisterNameString();
        Register register = this.applicator.getRegister(registerName);
        if (register != (sp = this.applicator.getProgram().getCompilerSpec().getStackPointer())) {
            return false;
        }
        Integer registerChange = applier.getRegisterPrologChange(register);
        StackFrame stackFrame = function.getStackFrame();
        int baseParamOffset = applier.getBaseParamOffset();
        long frameSize = applier.getCurrentFrameSize();
        if (registerChange == null) {
            registerChange = 0;
        }
        long relativeOffset = symbol.getOffset() + (long)registerChange.intValue();
        int offset = (int)(relativeOffset & 0xFFFFFFFFL);
        RecordNumber typeRecord = symbol.getTypeRecordNumber();
        DataType dt = this.applicator.getCompletedDataType(typeRecord);
        if (dt != null) {
            Variable variable = stackFrame.getVariableContaining(offset);
            try {
                if (variable == null || variable.getStackOffset() != offset) {
                    if (variable != null) {
                        stackFrame.clearVariable(variable.getStackOffset());
                    }
                    try {
                        variable = stackFrame.createVariable(symbol.getName(), offset, dt, SourceType.IMPORTED);
                    }
                    catch (DuplicateNameException e) {
                        variable = stackFrame.createVariable(symbol.getName() + "@" + Integer.toHexString(offset), offset, dt, SourceType.IMPORTED);
                    }
                } else {
                    variable.setDataType(dt, false, true, SourceType.ANALYSIS);
                    try {
                        variable.setName(symbol.getName(), SourceType.IMPORTED);
                    }
                    catch (DuplicateNameException e) {
                        variable.setName(symbol.getName() + "@" + Integer.toHexString(offset), SourceType.IMPORTED);
                    }
                }
            }
            catch (DuplicateNameException | InvalidInputException e) {
                this.applicator.appendLogMsg("Unable to create stack variable " + symbol.getName() + " at offset " + offset + " in " + function.getName());
                return false;
            }
        }
        return true;
    }

    @Override
    public void applyTo(NestingSymbolApplier applyToApplier, MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        if (!this.applicator.getPdbApplicatorOptions().applyFunctionVariables()) {
            return;
        }
        if (applyToApplier instanceof FunctionSymbolApplier) {
            FunctionSymbolApplier functionSymbolApplier = (FunctionSymbolApplier)applyToApplier;
            this.createFunctionVariable(functionSymbolApplier, this.symbol);
        }
    }

    private AbstractRegisterRelativeAddressMsSymbol getValidatedSymbol(MsSymbolIterator iter, boolean iterate) {
        AbstractMsSymbol abstractSymbol;
        AbstractMsSymbol abstractMsSymbol = abstractSymbol = iterate ? iter.next() : iter.peek();
        if (!(abstractSymbol instanceof AbstractRegisterRelativeAddressMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        AbstractRegisterRelativeAddressMsSymbol regRelSymbol = (AbstractRegisterRelativeAddressMsSymbol)abstractSymbol;
        return regRelSymbol;
    }
}

