/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.pdb.classtype.PlaceholderVirtualBaseTableEntry;
import ghidra.app.util.pdb.classtype.VirtualBaseTable;
import ghidra.program.model.gclass.ClassID;
import java.util.List;

public class PlaceholderVirtualBaseTable
extends VirtualBaseTable {
    public PlaceholderVirtualBaseTable(ClassID owner, List<ClassID> parentage) {
        super(owner, parentage);
    }

    public void setBaseClassOffsetAndId(int tableIndex, Long offset, ClassID baseId) {
        PlaceholderVirtualBaseTableEntry entry = this.entry(tableIndex);
        if (entry == null) {
            entry = new PlaceholderVirtualBaseTableEntry(offset, baseId);
            this.entryByTableIndex.put(tableIndex, entry);
            this.maxTableIndexSeen = Integer.max(this.maxTableIndexSeen, tableIndex);
        } else {
            entry.setOffset(offset);
            entry.setClassId(baseId);
        }
    }

    public void setBaseOffset(int tableIndex, Long offset) {
        PlaceholderVirtualBaseTableEntry entry = this.entry(tableIndex);
        if (entry == null) {
            entry = new PlaceholderVirtualBaseTableEntry(offset);
            this.entryByTableIndex.put(tableIndex, entry);
            this.maxTableIndexSeen = Integer.max(this.maxTableIndexSeen, tableIndex);
        } else {
            entry.setOffset(offset);
        }
    }

    @Override
    public PlaceholderVirtualBaseTableEntry getEntry(int tableIndex) {
        return (PlaceholderVirtualBaseTableEntry)this.entryByTableIndex.get(tableIndex);
    }

    @Override
    public Long getBaseOffset(int tableIndex) throws PdbException {
        PlaceholderVirtualBaseTableEntry entry = this.entry(tableIndex);
        Long offset = entry == null ? null : entry.getOffset();
        return offset;
    }

    @Override
    protected PlaceholderVirtualBaseTableEntry getNewEntry(ClassID baseId) {
        return new PlaceholderVirtualBaseTableEntry(baseId);
    }

    private PlaceholderVirtualBaseTableEntry entry(int tableIndex) {
        return (PlaceholderVirtualBaseTableEntry)this.entryByTableIndex.get(tableIndex);
    }

    private PlaceholderVirtualBaseTableEntry existing(int tableIndex) throws PdbException {
        PlaceholderVirtualBaseTableEntry entry = this.entry(tableIndex);
        if (entry == null) {
            throw new PdbException("No entry in Virtual Base Table for table index: " + tableIndex);
        }
        return entry;
    }
}

