/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;

public abstract class AbstractDimensionedArrayConstBoundsLowerUpperMsType
extends AbstractMsType {
    protected int rank;
    protected RecordNumber typeRecordNumber;
    protected long[] lowerBound;
    protected long[] upperBound;

    public AbstractDimensionedArrayConstBoundsLowerUpperMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.parseBeginningFields(reader);
        byte[] remainingData = reader.parseBytesRemaining();
        PdbByteReader boundsReader = new PdbByteReader(remainingData);
        int length = remainingData.length;
        if (length % (2 * this.rank) != 0) {
            throw new PdbException("We are not expecting this--needs investigation");
        }
        this.lowerBound = new long[this.rank];
        this.upperBound = new long[this.rank];
        int size = length / (2 * this.rank);
        switch (size) {
            case 1: {
                for (int i = 0; i < this.rank; ++i) {
                    this.lowerBound[i] = boundsReader.parseUnsignedByteVal();
                    this.upperBound[i] = boundsReader.parseUnsignedByteVal();
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.rank; ++i) {
                    this.lowerBound[i] = boundsReader.parseShort();
                    this.upperBound[i] = boundsReader.parseShort();
                }
                break;
            }
            case 4: {
                for (int i = 0; i < this.rank; ++i) {
                    this.lowerBound[i] = boundsReader.parseInt();
                    this.upperBound[i] = boundsReader.parseInt();
                }
                break;
            }
            case 8: {
                for (int i = 0; i < this.rank; ++i) {
                    this.lowerBound[i] = boundsReader.parseLong();
                    this.upperBound[i] = boundsReader.parseLong();
                }
                break;
            }
            default: {
                throw new PdbException("We are not expecting this--needs investigation");
            }
        }
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        this.pdb.getTypeRecord(this.typeRecordNumber).emit(builder, AbstractMsType.Bind.NONE);
        for (int i = 0; i < this.rank; ++i) {
            builder.append("[");
            builder.append(this.lowerBound[i]);
            builder.append(":");
            builder.append(this.upperBound[i]);
            builder.append("]");
        }
    }

    protected abstract void parseBeginningFields(PdbByteReader var1) throws PdbException;
}

