/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AddressMsSymbol;

public class IndirectCallSiteInfoMsSymbol
extends AbstractMsSymbol
implements AddressMsSymbol {
    public static final int PDB_ID = 4409;
    protected long offset;
    protected int section;
    protected int padding;
    protected RecordNumber typeRecordNumber;

    public IndirectCallSiteInfoMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.offset = reader.parseUnsignedIntVal();
        this.section = pdb.parseSegment(reader);
        this.padding = reader.parseUnsignedShortVal();
        if (this.padding != 0) {
            PdbLog.message("Non-zero padding (" + this.padding + " in " + this.getClass().getSimpleName() + ":\n" + reader.dump());
        }
        this.typeRecordNumber = RecordNumber.parseNoWitness(pdb, reader, RecordCategory.TYPE, 32);
        reader.align4();
    }

    @Override
    public int getPdbId() {
        return 4409;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public int getSegment() {
        return this.section;
    }

    public int getSection() {
        return this.section;
    }

    public RecordNumber getTypeRecordNumber() {
        return this.typeRecordNumber;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: [%04X:%08X], Type = %s\n", this.getSymbolTypeName(), this.section, this.offset, this.pdb.getTypeRecord(this.typeRecordNumber)));
    }

    @Override
    protected String getSymbolTypeName() {
        return "CALLSITEINFO";
    }
}

