/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.RegisterName;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;

public abstract class AbstractRegisterMsSymbol
extends AbstractMsSymbol {
    protected RecordNumber recordNumber;
    protected RegisterName register;
    protected String name;

    public AbstractRegisterMsSymbol(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.recordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.register = this.parseRegister(reader);
        this.name = reader.parseString(pdb, strType);
        reader.align4();
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(": ");
        this.emitRegisterInformation(builder);
        builder.append(", Type: ");
        builder.append(this.pdb.getTypeRecord(this.recordNumber));
        builder.append(", ");
        builder.append(this.name);
    }

    protected abstract RegisterName parseRegister(PdbByteReader var1) throws PdbException;

    protected abstract void emitRegisterInformation(StringBuilder var1);
}

