/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractSymbolInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfStream;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.io.Writer;

public class GlobalSymbolInformation
extends AbstractSymbolInformation {
    public GlobalSymbolInformation(AbstractPdb pdbIn, int streamNumber) {
        super(pdbIn, streamNumber);
    }

    @Override
    void initialize() throws IOException, PdbException, CancelledException {
        this.initializeValues();
        this.initializeGlobalOffsetsAndLengths();
        this.deserializeHashHeader();
    }

    private void initializeGlobalOffsetsAndLengths() {
        this.symbolHashOffset = 0;
        MsfStream stream = this.pdb.getMsf().getStream(this.streamNumber);
        this.symbolHashLength = stream == null ? 0 : stream.getLength();
    }

    @Override
    void dump(Writer writer) throws IOException, CancelledException, PdbException {
        writer.write("GlobalSymbolInformation-------------------------------------\n");
        this.dumpHashHeader(writer);
        this.dumpHashBasics(writer);
        this.dumpHashRecords(writer);
        writer.write("\nEnd GlobalSymbolInformation---------------------------------\n");
    }
}

