/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4GroupDescriptor
implements StructConverter {
    private int bg_block_bitmap_lo;
    private int bg_inode_bitmap_lo;
    private int bg_inode_table_lo;
    private short bg_free_blocks_count_lo;
    private short bg_free_inodes_count_lo;
    private short bg_used_dirs_count_lo;
    private short bg_flags;
    private int bg_exclude_bitmap_lo;
    private short bg_block_bitmap_csum_lo;
    private short bg_inode_bitmap_csum_lo;
    private short bg_itable_unused_lo;
    private short bg_checksum;
    private int bg_block_bitmap_hi;
    private int bg_inode_bitmap_hi;
    private int bg_inode_table_hi;
    private short bg_free_blocks_count_hi;
    private short bg_free_inodes_count_hi;
    private short bg_used_dirs_count_hi;
    private short bg_itable_unused_hi;
    private int bg_exclude_bitmap_hi;
    private short bg_block_bitmap_csum_hi;
    private short bg_inode_bitmap_csum_hi;
    private int bg_reserved;
    private boolean is64Bit;

    public Ext4GroupDescriptor(ByteProvider provider, boolean is64Bit) throws IOException {
        this(new BinaryReader(provider, true), is64Bit);
    }

    public Ext4GroupDescriptor(BinaryReader reader, boolean is64Bit) throws IOException {
        this.is64Bit = is64Bit;
        this.bg_block_bitmap_lo = reader.readNextInt();
        this.bg_inode_bitmap_lo = reader.readNextInt();
        this.bg_inode_table_lo = reader.readNextInt();
        this.bg_free_blocks_count_lo = reader.readNextShort();
        this.bg_free_inodes_count_lo = reader.readNextShort();
        this.bg_used_dirs_count_lo = reader.readNextShort();
        this.bg_flags = reader.readNextShort();
        this.bg_exclude_bitmap_lo = reader.readNextInt();
        this.bg_block_bitmap_csum_lo = reader.readNextShort();
        this.bg_inode_bitmap_csum_lo = reader.readNextShort();
        this.bg_itable_unused_lo = reader.readNextShort();
        this.bg_checksum = reader.readNextShort();
        if (!this.is64Bit) {
            return;
        }
        this.bg_block_bitmap_hi = reader.readNextInt();
        this.bg_inode_bitmap_hi = reader.readNextInt();
        this.bg_inode_table_hi = reader.readNextInt();
        this.bg_free_blocks_count_hi = reader.readNextShort();
        this.bg_free_inodes_count_hi = reader.readNextShort();
        this.bg_used_dirs_count_hi = reader.readNextShort();
        this.bg_itable_unused_hi = reader.readNextShort();
        this.bg_exclude_bitmap_hi = reader.readNextInt();
        this.bg_block_bitmap_csum_hi = reader.readNextShort();
        this.bg_inode_bitmap_csum_hi = reader.readNextShort();
        this.bg_reserved = reader.readNextInt();
    }

    public int getBg_block_bitmap_lo() {
        return this.bg_block_bitmap_lo;
    }

    public int getBg_inode_bitmap_lo() {
        return this.bg_inode_bitmap_lo;
    }

    public int getBg_inode_table_lo() {
        return this.bg_inode_table_lo;
    }

    public short getBg_free_blocks_count_lo() {
        return this.bg_free_blocks_count_lo;
    }

    public short getBg_free_inodes_count_lo() {
        return this.bg_free_inodes_count_lo;
    }

    public short getBg_used_dirs_count_lo() {
        return this.bg_used_dirs_count_lo;
    }

    public short getBg_flags() {
        return this.bg_flags;
    }

    public int getBg_exclude_bitmap_lo() {
        return this.bg_exclude_bitmap_lo;
    }

    public short getBg_block_bitmap_csum_lo() {
        return this.bg_block_bitmap_csum_lo;
    }

    public short getBg_inode_bitmap_csum_lo() {
        return this.bg_inode_bitmap_csum_lo;
    }

    public short getBg_itable_unused_lo() {
        return this.bg_itable_unused_lo;
    }

    public short getBg_checksum() {
        return this.bg_checksum;
    }

    public int getBg_block_bitmap_hi() {
        return this.bg_block_bitmap_hi;
    }

    public int getBg_inode_bitmap_hi() {
        return this.bg_inode_bitmap_hi;
    }

    public int getBg_inode_table_hi() {
        return this.bg_inode_table_hi;
    }

    public long getBg_inode_table() {
        return (long)this.bg_inode_table_hi << 32 | Integer.toUnsignedLong(this.bg_inode_table_lo);
    }

    public short getBg_free_blocks_count_hi() {
        return this.bg_free_blocks_count_hi;
    }

    public short getBg_free_inodes_count_hi() {
        return this.bg_free_inodes_count_hi;
    }

    public short getBg_used_dirs_count_hi() {
        return this.bg_used_dirs_count_hi;
    }

    public short getBg_itable_unused_hi() {
        return this.bg_itable_unused_hi;
    }

    public int getBg_exclude_bitmap_hi() {
        return this.bg_exclude_bitmap_hi;
    }

    public short getBg_block_bitmap_csum_hi() {
        return this.bg_block_bitmap_csum_hi;
    }

    public short getBg_inode_bitmap_csum_hi() {
        return this.bg_inode_bitmap_csum_hi;
    }

    public int getBg_reserved() {
        return this.bg_reserved;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("ext4_group_desc", 0);
        structure.add(DWORD, "bg_block_bitmap_lo", null);
        structure.add(DWORD, "bg_inode_bitmap_lo", null);
        structure.add(DWORD, "bg_inode_table_lo", null);
        structure.add(WORD, "bg_free_blocks_count_lo", null);
        structure.add(WORD, "bg_free_inodes_count_lo", null);
        structure.add(WORD, "bg_used_dirs_count_lo", null);
        structure.add(WORD, "bg_flags", null);
        structure.add(DWORD, "bg_exclude_bitmap_lo", null);
        structure.add(WORD, "bg_block_bitmap_csum_lo", null);
        structure.add(WORD, "bg_inode_bitmap_csum_lo", null);
        structure.add(WORD, "bg_itable_unused_lo", null);
        structure.add(WORD, "bg_checksum", null);
        if (this.is64Bit) {
            structure.add(DWORD, "bg_block_bitmap_hi", null);
            structure.add(DWORD, "bg_inode_bitmap_hi", null);
            structure.add(DWORD, "bg_inode_table_hi", null);
            structure.add(WORD, "bg_free_blocks_count_hi", null);
            structure.add(WORD, "bg_free_inodes_count_hi", null);
            structure.add(WORD, "bg_used_dirs_count_hi", null);
            structure.add(WORD, "bg_itable_unused_hi", null);
            structure.add(DWORD, "bg_exclude_bitmap_hi", null);
            structure.add(WORD, "bg_block_bitmap_csum_hi", null);
            structure.add(WORD, "bg_inode_bitmap_csum_hi", null);
            structure.add(DWORD, "bg_reserved", null);
        }
        return structure;
    }
}

