/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cart;

import ghidra.file.formats.cart.CartCancelDialogs;
import ghidra.file.formats.cart.CartInvalidCartException;
import ghidra.file.formats.cart.CartV1Constants;
import ghidra.file.formats.cart.CartV1File;
import ghidra.file.formats.cart.CartV1StreamProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class CartV1StreamHasher
extends CartV1StreamProcessor {
    private Map<String, MessageDigest> hashers = new LinkedHashMap<String, MessageDigest>();
    private Map<String, byte[]> hashes = new LinkedHashMap<String, byte[]>();
    private Map<String, byte[]> finalHashes = new LinkedHashMap<String, byte[]>();

    public CartV1StreamHasher(InputStream delegate, CartV1File cartFile) throws NoSuchAlgorithmException, CartInvalidCartException {
        super(delegate);
        ArrayList<String> missingHashes = new ArrayList<String>();
        for (Map.Entry<String, String> hashCheck : CartV1Constants.EXPECTED_HASHES.entrySet()) {
            byte[] footerHashValue = cartFile.getFooterHash(hashCheck.getKey());
            String hashName = hashCheck.getValue();
            if (footerHashValue != null) {
                this.hashes.put(hashCheck.getKey(), footerHashValue);
                this.hashers.put(hashCheck.getKey(), MessageDigest.getInstance(hashName));
                continue;
            }
            missingHashes.add(hashCheck.getKey());
        }
        if (!missingHashes.isEmpty() && !CartCancelDialogs.promptErrorContinue("Missing Hashes", "Expected hash(es) missing: " + String.join((CharSequence)", ", missingHashes) + ". Continue processing?")) {
            throw new CartInvalidCartException("Cancelled due to missing hash data (" + String.join((CharSequence)", ", missingHashes) + ").");
        }
    }

    @Override
    protected boolean readNextChunk() throws IOException {
        byte[] readBuffer = new byte[65536];
        int bytesRead = -1;
        this.currentChunk = null;
        this.chunkPos = 0;
        if (this.hashers.isEmpty()) {
            return false;
        }
        bytesRead = this.delegate.read(readBuffer);
        if (bytesRead <= 0) {
            for (Map.Entry<String, MessageDigest> hashCheck : this.hashers.entrySet()) {
                this.finalHashes.put(hashCheck.getKey(), hashCheck.getValue().digest());
            }
            this.hashers.clear();
            return false;
        }
        for (MessageDigest hasher : this.hashers.values()) {
            hasher.update(readBuffer, 0, bytesRead);
        }
        this.currentChunk = Arrays.copyOf(readBuffer, bytesRead);
        return this.currentChunk != null && this.currentChunk.length > 0;
    }

    public boolean checkHashes() throws CartInvalidCartException {
        ArrayList<String> verifiedHashes = new ArrayList<String>();
        ArrayList<String> badHashes = new ArrayList<String>();
        for (Map.Entry<String, byte[]> hashCheck : this.finalHashes.entrySet()) {
            byte[] footerHashValue = this.hashes.get(hashCheck.getKey());
            try {
                if (Arrays.equals(hashCheck.getValue(), footerHashValue)) {
                    verifiedHashes.add(hashCheck.getKey());
                    continue;
                }
                badHashes.add(hashCheck.getKey());
            }
            catch (IllegalArgumentException e) {
                badHashes.add(hashCheck.getKey());
            }
        }
        if (!badHashes.isEmpty()) {
            throw new CartInvalidCartException("Hash(es) " + String.join((CharSequence)", ", badHashes) + " in footer doesn't match CaRT data contents.");
        }
        if (verifiedHashes.isEmpty() && !CartCancelDialogs.promptErrorContinue("No Hashes", "No hash data in CaRT footer metadata. Cannot verify content. Continue processing?")) {
            throw new CartInvalidCartException("Cancelled due to no hash data.");
        }
        return badHashes.size() == 0 && verifiedHashes.size() > 0;
    }
}

