/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import java.util.HashSet;
import java.util.Set;

public class FidServiceUtil {
    static Set<Function> computeParents(Function function) {
        HashSet<Function> results = new HashSet<Function>();
        Program program = function.getProgram();
        FunctionManager functionManager = program.getFunctionManager();
        ReferenceManager referenceManager = program.getReferenceManager();
        ReferenceIterator referencesTo = referenceManager.getReferencesTo(function.getEntryPoint());
        for (Reference reference : referencesTo) {
            Function parent;
            if (!reference.getReferenceType().isCall() || (parent = functionManager.getFunctionContaining(reference.getFromAddress())) == null) continue;
            results.add(parent);
        }
        return results;
    }

    static Set<Function> computeChildren(Function function) {
        HashSet<Function> results = new HashSet<Function>();
        Program program = function.getProgram();
        FunctionManager functionManager = program.getFunctionManager();
        ReferenceManager referenceManager = program.getReferenceManager();
        AddressIterator referenceIterator = referenceManager.getReferenceSourceIterator(function.getBody(), true);
        for (Address address : referenceIterator) {
            Reference[] referencesFrom;
            for (Reference reference : referencesFrom = referenceManager.getReferencesFrom(address)) {
                Function child;
                if (!reference.getReferenceType().isCall() || (child = functionManager.getFunctionAt(reference.getToAddress())) == null) continue;
                results.add(child);
            }
        }
        return results;
    }
}

