/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.analyzer;

import ghidra.app.plugin.core.analysis.AnalysisOptionsUpdater;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.feature.fid.cmd.ApplyFidEntriesCommand;
import ghidra.feature.fid.service.FidService;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class FidAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Function ID";
    private static final String DESCRIPTION = "Finds known functions by hashing.";
    private FidService service;
    public static final String OPTION_NAME_CREATE_BOOKMARKS = "Create Analysis Bookmarks";
    private static final String OPTION_DESCRIPTION_CREATE_BOOKMARKS = "If checked, an analysis bookmark will be created for each function which was matched against one or more known library functions.";
    public static final String APPLY_ALL_FID_LABELS_OPTION_NAME = "Always Apply FID Labels";
    private static final String APPLY_ALL_FID_LABELS_OPTION_DESCRIPTION = "Enable this option to always apply FID labels at functions regardless of existing labels at that function. When enabled, FID labels will always be added. When disabled, FID labels will not be applied at functions where  there already exists a label with type IMPORTED or USER_DEFINED.";
    private static final boolean APPLY_ALL_FID_LABELS_DEFAULT = false;
    private static final boolean OPTION_DEFAULT_CREATE_BOOKMARKS_ENABLED = true;
    private boolean alwaysApplyFidLabels = false;
    private boolean createBookmarksEnabled = true;
    private static final String SCORE_THRESHOLD_OPTION_NAME = "Instruction Count Threshold";
    private static final String SCORE_THRESHOLD_OPTION_DESCRIPTION = "The minimum score that a potential match must meet to be labeled by the analyzer. Score corresponds roughly to the number of instructions in the function.";
    private float scoreThreshold;
    private static final String MULTIMATCH_THRESHOLD_OPTION_NAME = "Multiple Match Threshold";
    private static final String MULTIMATCH_THRESHOLD_OPTION_DESCRIPTION = "If there are multiple conflicting matches for a function, its score must exceed this secondary threshold in order to be labeled by the analyzer";
    private float multiScoreThreshold;
    private static final String SCORE_THRESHOLD_OPTION_NAME_OLD = "Instruction count threshold";
    private static final String MULTIMATCH_THRESHOLD_OPTION_NAME_OLD = "Multiple match threshold";
    private static final String APPLY_ALL_FID_LABELS_OPTION_NAME_OLD = "Always apply FID labels";
    private AnalysisOptionsUpdater optionsUpdater = new AnalysisOptionsUpdater();

    public FidAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.service = new FidService();
        this.setSupportsOneTimeAnalysis();
        this.setPriority(AnalysisPriority.FUNCTION_ID_ANALYSIS.before());
        this.scoreThreshold = this.service.getDefaultScoreThreshold();
        this.multiScoreThreshold = this.service.getDefaultMultiNameThreshold();
        this.optionsUpdater.registerReplacement(SCORE_THRESHOLD_OPTION_NAME, SCORE_THRESHOLD_OPTION_NAME_OLD);
        this.optionsUpdater.registerReplacement(MULTIMATCH_THRESHOLD_OPTION_NAME, MULTIMATCH_THRESHOLD_OPTION_NAME_OLD);
        this.optionsUpdater.registerReplacement(APPLY_ALL_FID_LABELS_OPTION_NAME, APPLY_ALL_FID_LABELS_OPTION_NAME_OLD);
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public boolean canAnalyze(Program program) {
        return true;
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        if (!this.service.canProcess(program.getLanguage())) {
            Msg.debug((Object)((Object)this), (Object)("No FID Libraries apply for language " + String.valueOf(program.getLanguageID())));
            return false;
        }
        if (!this.isFullExecutable(program, set)) {
            return true;
        }
        ApplyFidEntriesCommand cmd = new ApplyFidEntriesCommand(set, this.scoreThreshold, this.multiScoreThreshold, this.alwaysApplyFidLabels, this.createBookmarksEnabled);
        cmd.applyTo(program, monitor);
        AutoAnalysisManager.getAnalysisManager((Program)program).functionModifierChanged(cmd.getFIDLocations());
        return true;
    }

    private boolean isFullExecutable(Program program, AddressSetView set) {
        AddressSetView executeSet = program.getMemory().getExecuteSet();
        if (!executeSet.isEmpty()) {
            return set.contains(executeSet);
        }
        AddressSetView loadSet = program.getMemory().getLoadedAndInitializedAddressSet();
        return set.contains(loadSet);
    }

    public void registerOptions(Options options, Program program) {
        options.registerOption(SCORE_THRESHOLD_OPTION_NAME, (Object)Float.valueOf(this.service.getDefaultScoreThreshold()), null, SCORE_THRESHOLD_OPTION_DESCRIPTION);
        options.registerOption(MULTIMATCH_THRESHOLD_OPTION_NAME, (Object)Float.valueOf(this.service.getDefaultMultiNameThreshold()), null, MULTIMATCH_THRESHOLD_OPTION_DESCRIPTION);
        options.registerOption(APPLY_ALL_FID_LABELS_OPTION_NAME, (Object)false, null, APPLY_ALL_FID_LABELS_OPTION_DESCRIPTION);
        options.registerOption(OPTION_NAME_CREATE_BOOKMARKS, (Object)this.createBookmarksEnabled, null, OPTION_DESCRIPTION_CREATE_BOOKMARKS);
    }

    public AnalysisOptionsUpdater getOptionsUpdater() {
        return this.optionsUpdater;
    }

    public void optionsChanged(Options options, Program program) {
        this.scoreThreshold = options.getFloat(SCORE_THRESHOLD_OPTION_NAME, this.service.getDefaultScoreThreshold());
        this.multiScoreThreshold = options.getFloat(MULTIMATCH_THRESHOLD_OPTION_NAME, this.service.getDefaultMultiNameThreshold());
        this.alwaysApplyFidLabels = options.getBoolean(APPLY_ALL_FID_LABELS_OPTION_NAME, false);
        this.createBookmarksEnabled = options.getBoolean(OPTION_NAME_CREATE_BOOKMARKS, this.createBookmarksEnabled);
    }
}

