/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.register;

import db.Transaction;
import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.actions.PopupActionProvider;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.HexBigIntegerTableCellEditor;
import docking.widgets.table.HexDefaultGColumnRenderer;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableColumnDescriptor;
import generic.theme.GColor;
import ghidra.app.plugin.core.data.DataSettingsDialog;
import ghidra.app.plugin.core.debug.gui.DebuggerProvider;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.register.DebuggerAvailableRegistersDialog;
import ghidra.app.plugin.core.debug.gui.register.DebuggerRegisterActionContext;
import ghidra.app.plugin.core.debug.gui.register.DebuggerRegisterColumnFactory;
import ghidra.app.plugin.core.debug.gui.register.DebuggerRegistersPlugin;
import ghidra.app.plugin.core.debug.gui.register.RegisterRow;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.MarkerService;
import ghidra.async.AsyncLazyValue;
import ghidra.async.AsyncUtils;
import ghidra.base.widgets.table.DataTypeTableCellEditor;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeEncodeException;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.listing.TraceCodeSpace;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.data.DataTypeParser;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DebuggerRegistersProvider
extends ComponentProviderAdapter
implements DebuggerProvider,
PopupActionProvider {
    private static final GColor COLOR_BORDER_DISCONNECTED = new GColor("color.border.provider.disconnected");
    private static final Color COLOR_FOREGROUND_STALE = new GColor("color.debugger.plugin.resources.register.stale");
    private static final Color COLOR_FOREGROUND_STALE_SEL = new GColor("color.debugger.plugin.resources.register.stale.selected");
    private static final Color COLOR_FOREGROUND_CHANGED = new GColor("color.debugger.plugin.resources.register.changed");
    private static final Color COLOR_FOREGROUND_CHANGED_SEL = new GColor("color.debugger.plugin.resources.register.changed.selected");
    private static final String KEY_DEBUGGER_COORDINATES = "DebuggerCoordinates";
    final DebuggerRegistersPlugin plugin;
    private final Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> selectionByCSpec;
    private final Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> favoritesByCSpec;
    private final boolean isClone;
    DebuggerCoordinates previous = DebuggerCoordinates.NOWHERE;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    private AsyncLazyValue<Void> readTheseCoords = new AsyncLazyValue(this::readRegistersIfLiveAndAccessible);
    private Trace currentTrace;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    @AutoServiceConsumed
    private DebuggerControlService controlService;
    @AutoServiceConsumed
    private DebuggerConsoleService consoleService;
    @AutoServiceConsumed
    private MarkerService markerService;
    private final AutoService.Wiring autoServiceWiring;
    private final AutoOptions.Wiring autoOptionsWiring;
    private final TraceChangeListener traceChangeListener = new TraceChangeListener();
    private JPanel mainPanel = new JPanel(new BorderLayout());
    final RegistersTableModel regsTableModel;
    GhidraTable regsTable;
    GhidraTableFilterPanel<RegisterRow> regsFilterPanel;
    Map<Register, RegisterRow> regMap = new IdentityHashMap<Register, RegisterRow>();
    private final DebuggerAvailableRegistersDialog availableRegsDialog;
    DockingAction actionSelectRegisters;
    DockingAction actionCreateSnapshot;
    ToggleDockingAction actionEnableEdits;
    DockingAction actionClearDataType;
    DockingAction actionDataTypeSettings;
    DebuggerRegisterActionContext myActionContext;
    AddressSetView viewKnown;

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getPlatform(), b.getPlatform())) {
            return false;
        }
        if (!Objects.equals(a.getTarget(), b.getTarget())) {
            return false;
        }
        if (!Objects.equals(a.getThread(), b.getThread())) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        return Objects.equals(a.getFrame(), b.getFrame());
    }

    protected DebuggerRegistersProvider(DebuggerRegistersPlugin plugin, Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> selectionByCSpec, Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> favoritesByCSpec, boolean isClone) {
        super(plugin.getTool(), "Registers", plugin.getName());
        this.plugin = plugin;
        this.regsTableModel = new RegistersTableModel(this.tool);
        this.selectionByCSpec = selectionByCSpec;
        this.favoritesByCSpec = favoritesByCSpec;
        this.isClone = isClone;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)this);
        this.autoOptionsWiring = AutoOptions.wireOptions((Plugin)plugin, (Object)this);
        this.setIcon(DebuggerResources.ICON_PROVIDER_REGISTERS);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_REGISTERS);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        plugin.getTool().addPopupActionProvider((PopupActionProvider)this);
        this.availableRegsDialog = new DebuggerAvailableRegistersDialog(this);
        this.setDefaultWindowPosition(WindowPosition.RIGHT);
        this.createActions();
        if (isClone) {
            this.setTitle("[Registers]");
            this.setWindowGroup("Debugger.Core.disconnected");
            this.setIntraGroupPosition(WindowPosition.STACK);
            this.mainPanel.setBorder(BorderFactory.createLineBorder((Color)COLOR_BORDER_DISCONNECTED, 2));
            this.setTransient();
        } else {
            this.setTitle("Registers");
            this.setWindowGroup("Debugger.Core");
        }
        this.setVisible(true);
        this.contextChanged();
    }

    public void removeFromTool() {
        this.availableRegsDialog.dispose();
        this.plugin.providerRemoved(this);
        this.plugin.getTool().removePopupActionProvider((PopupActionProvider)this);
        super.removeFromTool();
    }

    protected void buildMainPanel() {
        this.regsTable = new GhidraTable((TableModel)((Object)this.regsTableModel));
        this.mainPanel.add(new JScrollPane((Component)this.regsTable));
        this.regsFilterPanel = new GhidraTableFilterPanel((JTable)this.regsTable, (RowObjectTableModel)this.regsTableModel);
        this.mainPanel.add((Component)this.regsFilterPanel, "South");
        String namePrefix = "Registers";
        this.regsTable.setAccessibleNamePrefix(namePrefix);
        this.regsFilterPanel.setAccessibleNamePrefix(namePrefix);
        this.regsTable.getSelectionModel().addListSelectionListener(evt -> {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            this.myActionContext = new DebuggerRegisterActionContext(this, (RegisterRow)this.regsFilterPanel.getSelectedItem(), (GTable)this.regsTable);
            this.contextChanged();
        });
        this.regsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    DebuggerRegistersProvider.this.navigateToAddress();
                }
            }
        });
        this.regsTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DebuggerRegistersProvider.this.navigateToAddress();
                }
            }
        });
        TableColumnModel columnModel = this.regsTable.getColumnModel();
        TableColumn valCol = columnModel.getColumn(RegisterTableColumns.VALUE.ordinal());
        valCol.setCellEditor((TableCellEditor)new HexBigIntegerTableCellEditor());
        TableColumn typeCol = columnModel.getColumn(RegisterTableColumns.TYPE.ordinal());
        typeCol.setCellEditor((TableCellEditor)((Object)new RegisterDataTypeEditor()));
    }

    public List<DockingActionIf> getPopupActions(Tool t, ActionContext context) {
        if (context != this.myActionContext || context == null || this.listingService == null) {
            return List.of();
        }
        Register register = this.myActionContext.getSelected().getRegister();
        BigInteger value = this.getRegisterValue(register);
        if (value == null) {
            return List.of();
        }
        long lv = value.longValue();
        ArrayList<DockingActionIf> result = new ArrayList<DockingActionIf>();
        String pluginName = this.plugin.getName();
        for (AddressSpace space : this.currentTrace.getBaseAddressFactory().getAddressSpaces()) {
            Address address;
            if (!space.isMemorySpace() || space.getType() == 7) continue;
            try {
                address = space.getAddress(lv, true);
            }
            catch (AddressOutOfBoundsException e) {
                continue;
            }
            String name = "Go To " + address.toString(true);
            boolean enabled = this.currentTrace.getProgramView().getMemory().contains(address);
            String extraDesc = enabled ? "" : ". Enable via Force Full View.";
            result.add((DockingActionIf)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(name, pluginName).popupMenuPath(new String[]{name})).popupMenuGroup("Go To")).description("Navigate the dynamic listing to " + address.toString(true) + extraDesc)).helpLocation(new HelpLocation(pluginName, "go_to"))).enabledWhen(ctx -> enabled)).popupWhen(ctx -> true)).onAction(ctx -> {
                if (this.listingService == null) {
                    return;
                }
                ProgramLocation loc = new ProgramLocation((Program)this.current.getView(), address);
                this.listingService.goTo(loc, true);
            })).build());
        }
        return result;
    }

    protected void navigateToAddress() {
        if (this.listingService == null || this.myActionContext == null) {
            return;
        }
        RegisterRow row = this.myActionContext.getSelected();
        TraceData data = this.getRegisterData(row.getRegister());
        if (data == null || data.getValueClass() != Address.class) {
            return;
        }
        Address address = (Address)data.getValue();
        if (address == null) {
            return;
        }
        ProgramLocation loc = new ProgramLocation((Program)this.current.getView(), address);
        this.listingService.goTo(loc, true);
    }

    @Override
    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    protected void createActions() {
        this.actionSelectRegisters = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.SelectRegistersAction.builder(this.plugin).enabledWhen(c -> this.current.getThread() != null)).onAction(c -> this.selectRegistersActivated())).buildAndInstallLocal((ComponentProvider)this);
        if (!this.isClone) {
            this.actionCreateSnapshot = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.CloneWindowAction.builder(this.plugin).enabledWhen(c -> this.current.getThread() != null)).onAction(c -> this.cloneWindowActivated())).buildAndInstallLocal((ComponentProvider)this);
        }
        this.actionEnableEdits = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.EnableEditsAction.builder(this.plugin).enabledWhen(c -> this.current.getThread() != null)).onAction(c -> {})).buildAndInstallLocal((ComponentProvider)this);
        this.actionClearDataType = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)ClearRegisterType.builder(this.plugin).enabledWhen(c -> this.current.getThread() != null)).keyBinding(KeyStroke.getKeyStroke(127, 0))).onAction(c -> this.clearDataTypeActivated())).buildAndInstallLocal((ComponentProvider)this);
        this.actionDataTypeSettings = (DockingAction)RegisterTypeSettings.builder(this.plugin).withContext(DebuggerRegisterActionContext.class).enabledWhen(this::contextHasSingleRegisterWithType).onAction(this::dataTypeSettingsActivated).buildAndInstallLocal((ComponentProvider)this);
    }

    private void selectRegistersActivated() {
        TracePlatform curPlatform = this.current.getPlatform();
        if (this.current.getThread() == null) {
            return;
        }
        this.availableRegsDialog.setLanguage(curPlatform.getLanguage());
        LinkedHashSet<Register> viewKnown = this.computeDefaultRegisterSelection(curPlatform);
        this.availableRegsDialog.setKnown(viewKnown);
        Set<Register> selection = this.getSelectionFor(curPlatform);
        this.availableRegsDialog.setSelection(selection);
        this.tool.showDialog((DialogComponentProvider)this.availableRegsDialog);
    }

    private void cloneWindowActivated() {
        DebuggerRegistersProvider clone = this.cloneAsDisconnected();
        clone.setIntraGroupPosition(WindowPosition.RIGHT);
        this.tool.showComponentProvider((ComponentProvider)clone, true);
    }

    private void clearDataTypeActivated() {
        if (this.myActionContext == null) {
            return;
        }
        RegisterRow row = this.myActionContext.getSelected();
        row.setDataType(null);
    }

    private boolean contextHasSingleRegisterWithType(DebuggerRegisterActionContext ctx) {
        return ctx.getSelected() != null && ctx.getSelected().getData() != null;
    }

    private void dataTypeSettingsActivated(DebuggerRegisterActionContext ctx) {
        RegisterRow row = ctx.getSelected();
        if (row == null) {
            return;
        }
        Data data = row.getData();
        if (data == null) {
            return;
        }
        this.tool.showDialog((DialogComponentProvider)new RegisterDataSettingsDialog(data));
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public boolean isSnapshot() {
        return this.isClone;
    }

    protected String computeSubTitle() {
        TraceThread curThread = this.current.getThread();
        return curThread == null ? "" : curThread.getName(this.current.getSnap());
    }

    protected void updateSubTitle() {
        this.setSubTitle(this.computeSubTitle());
    }

    private void removeOldTraceListener() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.traceChangeListener);
    }

    private void addNewTraceListener() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.traceChangeListener);
    }

    private void doSetTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.actionEnableEdits.setSelected(false);
        this.removeOldTraceListener();
        this.currentTrace = trace;
        this.addNewTraceListener();
    }

    public boolean coordinatesActivated(DebuggerCoordinates coordinates) {
        if (DebuggerRegistersProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return false;
        }
        this.previous = this.current;
        this.current = coordinates;
        this.readTheseCoords.forget();
        this.doSetTrace(this.current.getTrace());
        this.updateSubTitle();
        this.prepareRegisterSpace();
        this.recomputeViewKnown();
        this.loadRegistersAndValues(this.previous.getLanguage() != this.current.getLanguage());
        this.contextChanged();
        return true;
    }

    protected void traceClosed(Trace trace) {
        if (this.isClone && this.current.getTrace() == trace) {
            this.coordinatesActivated(DebuggerCoordinates.NOWHERE);
            this.removeFromTool();
        }
    }

    boolean canWriteRegister(Register register) {
        if (!this.isEditsEnabled()) {
            return false;
        }
        if (this.controlService == null) {
            return false;
        }
        DebuggerControlService.StateEditor editor = this.controlService.createStateEditor(this.current);
        return editor.isRegisterEditable(register);
    }

    BigInteger getRegisterValue(Register register) {
        TraceMemorySpace regs = this.getRegisterMemorySpace(register.getAddressSpace(), false);
        if (regs == null) {
            return BigInteger.ZERO;
        }
        return regs.getViewValue(this.current.getPlatform(), this.current.getViewSnap(), register).getUnsignedValue();
    }

    void writeRegisterValue(Register register, BigInteger value) {
        this.writeRegisterValue(new RegisterValue(register, value));
    }

    void writeRegisterValue(RegisterValue rv) {
        if (this.controlService == null) {
            Msg.showError((Object)this, (Component)this.getComponent(), (String)"Edit Register", (Object)"No control service.");
            return;
        }
        DebuggerControlService.StateEditor editor = this.controlService.createStateEditor(this.current);
        if (!editor.isRegisterEditable(rv.getRegister())) {
            Msg.showError((Object)this, (Component)this.getComponent(), (String)"Edit Register", (Object)"Neither the register nor any parent can be edited.");
            return;
        }
        CompletableFuture future = editor.setRegister(rv);
        future.exceptionally(ex -> {
            ex = AsyncUtils.unwrapThrowable((Throwable)ex);
            this.reportError(null, "Could not write target register", (Throwable)ex);
            return null;
        });
    }

    void writeRegisterDataType(Register register, DataType dataType) {
        try (Transaction tx = this.current.getTrace().openTransaction("Edit Register Type");){
            if (dataType instanceof Pointer) {
                Pointer ptrType = (Pointer)dataType;
                if (register.getAddress().isRegisterAddress()) {
                    ptrType = (Pointer)this.current.getTrace().getDataTypeManager().resolve(dataType, DataTypeConflictHandler.DEFAULT_HANDLER);
                    AddressSpace space = this.current.getTrace().getBaseAddressFactory().getDefaultAddressSpace();
                    dataType = new PointerTypedef(null, ptrType.getDataType(), ptrType.getLength(), ptrType.getDataTypeManager(), space);
                }
            }
            TraceCodeSpace code = this.getRegisterMemorySpace(register.getAddressSpace(), true).getCodeSpace(true);
            long snap = this.current.getViewSnap();
            TracePlatform platform = this.current.getPlatform();
            code.definedUnits().clear(platform, Lifespan.at((long)snap), register, TaskMonitor.DUMMY);
            if (dataType != null) {
                code.definedData().create(platform, Lifespan.nowOn((long)snap), register, dataType);
            }
        }
        catch (CodeUnitInsertionException | CancelledException e) {
            throw new AssertionError((Object)e);
        }
    }

    TraceData getRegisterData(Register register) {
        TraceCodeSpace space = this.getRegisterCodeSpace(register.getAddressSpace(), false);
        if (space == null) {
            return null;
        }
        TracePlatform platform = this.current.getPlatform();
        long snap = this.current.getViewSnap();
        return (TraceData)space.definedData().getForRegister(platform, snap, register);
    }

    DataType getRegisterDataType(Register register) {
        TraceData data = this.getRegisterData(register);
        if (data == null) {
            return null;
        }
        return data.getDataType();
    }

    void writeRegisterValueRepresentation(Register register, String representation) {
        TraceData data = this.getRegisterData(register);
        if (data == null) {
            this.tool.setStatusInfo("Register has no data type", true);
            return;
        }
        try {
            RegisterValue rv = TraceRegisterUtils.encodeValueRepresentationHackPointer((Register)register, (TraceData)data, (String)representation);
            this.writeRegisterValue(rv);
        }
        catch (DataTypeEncodeException e) {
            this.tool.setStatusInfo(e.getMessage(), true);
            return;
        }
    }

    boolean canWriteRegisterRepresentation(Register register) {
        if (!this.canWriteRegister(register)) {
            return false;
        }
        TraceData data = this.getRegisterData(register);
        if (data == null) {
            return false;
        }
        return data.getBaseDataType().isEncodable();
    }

    String getRegisterValueRepresentation(Register register) {
        TraceData data = this.getRegisterData(register);
        if (data == null) {
            return null;
        }
        return data.getDefaultValueRepresentation();
    }

    void prepareRegisterSpace() {
        AddressSpace regSpace;
        Trace trace = this.current.getTrace();
        if (this.current.getThread() != null && trace.getObjectManager().getRootSchema() != null && (regSpace = this.current.getPlatform().getAddressFactory().getRegisterSpace()) != null) {
            try (Transaction tx = trace.openTransaction("Create/initialize register space");){
                this.getRegisterMemorySpace(regSpace, true);
            }
        }
    }

    void recomputeViewKnown() {
        TracePlatform platform = this.current.getPlatform();
        if (platform == null) {
            this.viewKnown = null;
            return;
        }
        TraceProgramView view = this.current.getView();
        if (view == null) {
            this.viewKnown = null;
            return;
        }
        TraceMemoryManager mem = this.current.getTrace().getMemoryManager();
        AddressSetView guestRegs = platform.getLanguage().getRegisterAddresses();
        AddressSetView hostRegs = platform.mapGuestToHost(guestRegs);
        AddressSetView viewKnownMem = view.getViewport().unionedAddresses(snap -> mem.getAddressesWithState(snap.longValue(), hostRegs, state -> state == TraceMemoryState.KNOWN));
        AddressSpace regSpace = platform.getAddressFactory().getRegisterSpace();
        if (regSpace == null) {
            this.viewKnown = new AddressSet(viewKnownMem);
            return;
        }
        TraceMemorySpace regs = DebuggerRegistersProvider.getRegisterMemorySpace(this.current, regSpace, false);
        if (regs == null) {
            this.viewKnown = new AddressSet(viewKnownMem);
            return;
        }
        AddressSetView overlayRegs = TraceRegisterUtils.getOverlaySet((AddressSpace)regs.getAddressSpace(), (AddressSetView)hostRegs);
        AddressSetView viewKnownRegs = view.getViewport().unionedAddresses(snap -> regs.getAddressesWithState(snap.longValue(), overlayRegs, state -> state == TraceMemoryState.KNOWN));
        this.viewKnown = viewKnownRegs.union(viewKnownMem);
    }

    boolean isRegisterKnown(Register register) {
        if (this.viewKnown == null) {
            return false;
        }
        TraceMemorySpace regs = DebuggerRegistersProvider.getRegisterMemorySpace(this.current, register.getAddressSpace(), false);
        if (regs == null && register.getAddressSpace().isRegisterSpace()) {
            return false;
        }
        AddressRange range = this.current.getPlatform().getConventionalRegisterRange(regs == null ? null : regs.getAddressSpace(), register);
        return this.viewKnown.contains(range.getMinAddress(), range.getMaxAddress());
    }

    boolean isRegisterChanged(Register register) {
        RegisterValue prevRegVal;
        if (this.previous.getThread() == null || this.current.getThread() == null) {
            return false;
        }
        if (this.previous.getPlatform().getLanguage() != this.current.getPlatform().getLanguage()) {
            return false;
        }
        if (!this.isRegisterKnown(register)) {
            return false;
        }
        TraceMemorySpace curSpace = DebuggerRegistersProvider.getRegisterMemorySpace(this.current, register.getAddressSpace(), false);
        TraceMemorySpace prevSpace = DebuggerRegistersProvider.getRegisterMemorySpace(this.previous, register.getAddressSpace(), false);
        if (prevSpace == null) {
            return false;
        }
        RegisterValue curRegVal = curSpace.getViewValue(this.current.getPlatform(), this.current.getViewSnap(), register);
        return !Objects.equals(curRegVal, prevRegVal = prevSpace.getViewValue(this.current.getPlatform(), this.previous.getViewSnap(), register));
    }

    private boolean isEditsEnabled() {
        return this.actionEnableEdits.isSelected();
    }

    public static LinkedHashSet<Register> collectCommonRegisters(CompilerSpec cSpec) {
        Register pc;
        Language lang = cSpec.getLanguage();
        LinkedHashSet<Register> result = new LinkedHashSet<Register>();
        Register sp = cSpec.getStackPointer();
        if (sp != null) {
            result.add(sp);
        }
        if ((pc = lang.getProgramCounter()) != null) {
            result.add(pc);
        }
        for (Register reg : lang.getRegisters()) {
            if (reg.isProcessorContext()) continue;
            result.add(reg);
        }
        return result;
    }

    public LinkedHashSet<Register> computeDefaultRegisterSelection(TracePlatform platform) {
        return DebuggerRegistersProvider.collectCommonRegisters(platform.getCompilerSpec());
    }

    public LinkedHashSet<Register> computeDefaultRegisterFavorites(TracePlatform platform) {
        LinkedHashSet<Register> favorites = new LinkedHashSet<Register>();
        favorites.add(platform.getLanguage().getProgramCounter());
        favorites.add(platform.getCompilerSpec().getStackPointer());
        return favorites;
    }

    protected static TraceMemorySpace getRegisterMemorySpace(DebuggerCoordinates coords, AddressSpace space, boolean createIfAbsent) {
        if (!space.isRegisterSpace()) {
            return coords.getTrace().getMemoryManager().getMemorySpace(space, createIfAbsent);
        }
        TraceThread thread = coords.getThread();
        if (thread == null) {
            return null;
        }
        return coords.getTrace().getMemoryManager().getMemoryRegisterSpace(thread, coords.getFrame(), createIfAbsent);
    }

    protected TraceMemorySpace getRegisterMemorySpace(AddressSpace space, boolean createIfAbsent) {
        return DebuggerRegistersProvider.getRegisterMemorySpace(this.current, space, createIfAbsent);
    }

    protected static TraceCodeSpace getRegisterCodeSpace(DebuggerCoordinates coords, AddressSpace space, boolean createIfAbsent) {
        if (!space.isRegisterSpace()) {
            return coords.getTrace().getCodeManager().getCodeSpace(space, createIfAbsent);
        }
        TraceThread thread = coords.getThread();
        if (thread == null) {
            return null;
        }
        return coords.getTrace().getCodeManager().getCodeRegisterSpace(thread, coords.getFrame(), createIfAbsent);
    }

    protected TraceCodeSpace getRegisterCodeSpace(AddressSpace space, boolean createIfAbsent) {
        return DebuggerRegistersProvider.getRegisterCodeSpace(this.current, space, createIfAbsent);
    }

    protected Set<Register> collectBaseRegistersWithKnownValues(TraceThread thread) {
        TraceMemorySpace mem = thread.getTrace().getMemoryManager().getMemoryRegisterSpace(thread, false);
        LinkedHashSet<Register> result = new LinkedHashSet<Register>();
        if (mem == null) {
            return result;
        }
        AddressSpace regSpace = thread.getTrace().getBaseAddressFactory().getRegisterSpace();
        AddressSet everKnown = new AddressSet();
        for (Map.Entry entry : mem.getMostRecentStates(thread.getTrace().getTimeManager().getMaxSnap().longValue(), (AddressRange)new AddressRangeImpl(regSpace.getMinAddress(), regSpace.getMaxAddress()))) {
            everKnown.add(((TraceAddressSnapRange)entry.getKey()).getRange());
        }
        for (Register reg : thread.getRegisters()) {
            AddressRange regRange;
            if (!reg.isBaseRegister() || !everKnown.intersects((regRange = TraceRegisterUtils.rangeForRegister((Register)reg)).getMinAddress(), regRange.getMaxAddress()) || !reg.isBaseRegister()) continue;
            result.add(reg);
        }
        return result;
    }

    protected static LanguageCompilerSpecPair getLangCSpecPair(TracePlatform platform) {
        return new LanguageCompilerSpecPair(platform.getLanguage().getLanguageID(), platform.getCompilerSpec().getCompilerSpecID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Register> getSelectionFor(TracePlatform platform) {
        Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> map = this.selectionByCSpec;
        synchronized (map) {
            LanguageCompilerSpecPair lcsp = DebuggerRegistersProvider.getLangCSpecPair(platform);
            return this.selectionByCSpec.computeIfAbsent(lcsp, __ -> this.computeDefaultRegisterSelection(platform));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Register> getFavoritesFor(TracePlatform platform) {
        Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> map = this.favoritesByCSpec;
        synchronized (map) {
            LanguageCompilerSpecPair lcsp = DebuggerRegistersProvider.getLangCSpecPair(platform);
            return this.favoritesByCSpec.computeIfAbsent(lcsp, __ -> this.computeDefaultRegisterFavorites(platform));
        }
    }

    protected void setFavorite(Register register, boolean favorite) {
        Set<Register> favorites = this.getFavoritesFor(this.current.getPlatform());
        if (favorite) {
            favorites.add(register);
        } else {
            favorites.remove(register);
        }
    }

    public boolean isFavorite(Register register) {
        Set<Register> favorites = this.getFavoritesFor(this.current.getPlatform());
        return favorites.contains(register);
    }

    public CompletableFuture<Void> setSelectedRegistersAndLoad(Collection<Register> selectedRegisters) {
        Set<Register> selection = this.getSelectionFor(this.current.getPlatform());
        selection.clear();
        selection.addAll(new TreeSet<Register>(selectedRegisters));
        return this.loadRegistersAndValues(false);
    }

    public RegisterRow getRegisterRow(Register register) {
        return this.regMap.get(register);
    }

    public void setSelectedRow(RegisterRow row) {
        this.regsFilterPanel.setSelectedItem((Object)row);
    }

    public DebuggerRegistersProvider cloneAsDisconnected() {
        DebuggerRegistersProvider clone = this.plugin.createNewDisconnectedProvider();
        clone.coordinatesActivated(this.current);
        return clone;
    }

    protected void displaySelectedRegisters(Set<Register> selected) {
        List regs = this.current.getPlatform().getLanguage().getRegisters();
        ArrayList<RegisterRow> toDelete = new ArrayList<RegisterRow>();
        Iterator<Map.Entry<Register, RegisterRow>> it = this.regMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Register, RegisterRow> ent = it.next();
            if (selected.contains(ent.getKey())) continue;
            toDelete.add(ent.getValue());
            it.remove();
        }
        this.regsTableModel.deleteWith(toDelete::contains);
        ArrayList toAdd = new ArrayList();
        for (Register reg : selected) {
            this.regMap.computeIfAbsent(reg, r -> {
                RegisterRow row = new RegisterRow(this, regs.indexOf(reg), reg);
                toAdd.add(row);
                return row;
            });
        }
        this.regsTableModel.addAll(toAdd);
    }

    protected CompletableFuture<Void> loadRegistersAndValues(boolean changeLanguage) {
        if (this.current.getThread() == null) {
            this.regsTableModel.clear();
            this.regMap.clear();
            return AsyncUtils.nil();
        }
        if (changeLanguage) {
            this.regsTableModel.clear();
            this.regMap.clear();
        }
        Set<Register> selected = this.getSelectionFor(this.current.getPlatform());
        this.displaySelectedRegisters(selected);
        return this.loadValues();
    }

    protected CompletableFuture<Void> loadValues() {
        TraceThread curThread = this.current.getThread();
        if (curThread == null) {
            return AsyncUtils.nil();
        }
        this.regsTableModel.fireTableDataChanged();
        return this.readTheseCoords.request();
    }

    protected CompletableFuture<Void> readRegistersIfLiveAndAccessible() {
        Target target = this.current.getTarget();
        if (!this.current.isAliveAndReadsPresent()) {
            return AsyncUtils.nil();
        }
        Set<Register> registers = this.getSelectionFor(this.current.getPlatform());
        CompletableFuture future = target.readRegistersAsync(this.current.getPlatform(), this.current.getThread(), this.current.getFrame(), registers);
        return ((CompletableFuture)future.exceptionally(ex -> {
            ex = AsyncUtils.unwrapThrowable((Throwable)ex);
            this.reportError(null, "Could not read target registers for selected thread", (Throwable)ex);
            return (Void)ExceptionUtils.rethrow((Throwable)ex);
        })).thenApply(__ -> null);
    }

    public void writeDataState(SaveState saveState) {
        if (this.isClone) {
            this.current.writeDataState(this.tool, saveState, KEY_DEBUGGER_COORDINATES);
        }
    }

    public void readDataState(SaveState saveState) {
        if (this.isClone) {
            this.coordinatesActivated(DebuggerCoordinates.readDataState((PluginTool)this.tool, (SaveState)saveState, (String)KEY_DEBUGGER_COORDINATES));
        }
    }

    public DebuggerCoordinates getCurrent() {
        return this.current;
    }

    private void reportError(String title, String message, Throwable ex) {
        this.plugin.getTool().setStatusInfo(message + ": " + ex.getMessage());
        if (title != null) {
            Msg.showError((Object)this, (Component)this.getComponent(), (String)title, (Object)message, (Throwable)ex);
        } else if (this.consoleService != null) {
            this.consoleService.log(DebuggerResources.ICON_LOG_ERROR, message, ex);
        } else {
            Msg.error((Object)this, (Object)message, (Throwable)ex);
        }
    }

    class TraceChangeListener
    extends TraceDomainObjectListener {
        public TraceChangeListener() {
            this.listenForUntyped((EventType)DomainObjectEvent.RESTORED, e -> this.objectRestored((DomainObjectChangeRecord)e));
            this.listenFor((TraceEvent)TraceEvents.BYTES_CHANGED, this::registerValueChanged);
            this.listenFor((TraceEvent)TraceEvents.BYTES_STATE_CHANGED, this::registerStateChanged);
            this.listenFor((TraceEvent)TraceEvents.CODE_ADDED, this::registerTypeAdded);
            this.listenFor((TraceEvent)TraceEvents.CODE_DATA_TYPE_REPLACED, this::registerTypeReplaced);
            this.listenFor((TraceEvent)TraceEvents.CODE_LIFESPAN_CHANGED, this::registerTypeLifespanChanged);
            this.listenFor((TraceEvent)TraceEvents.CODE_REMOVED, this::registerTypeRemoved);
            this.listenFor((TraceEvent)TraceEvents.THREAD_DELETED, this::threadDeleted);
            this.listenFor((TraceEvent)TraceEvents.THREAD_LIFESPAN_CHANGED, this::threadDestroyed);
        }

        private boolean isVisible(AddressSpace space) {
            if (!space.isRegisterSpace()) {
                return true;
            }
            TraceThread curThread = DebuggerRegistersProvider.this.current.getThread();
            if (curThread == null) {
                return false;
            }
            if (space.isOverlaySpace()) {
                return DebuggerRegistersProvider.this.current.isRegisterSpace(space);
            }
            if (space.isRegisterSpace()) {
                throw new AssertionError();
            }
            return false;
        }

        private boolean isVisible(AddressSpace space, TraceAddressSnapRange range) {
            if (!this.isVisible(space)) {
                return false;
            }
            if (space.isMemorySpace()) {
                return DebuggerRegistersProvider.this.current.getPlatform().getLanguage().getRegisterAddresses().intersects(range.getX1(), range.getX2());
            }
            TraceProgramView view = DebuggerRegistersProvider.this.current.getView();
            return view != null && view.getViewport().containsAnyUpper(range.getLifespan());
        }

        private void refreshRange(AddressRange range) {
            TraceMemorySpace mem = DebuggerRegistersProvider.this.getRegisterMemorySpace(range.getAddressSpace(), false);
            assert (mem != null);
            DebuggerRegistersProvider.this.regsTableModel.fireTableDataChanged();
        }

        private void objectRestored(DomainObjectChangeRecord rec) {
            if (!DebuggerRegistersProvider.this.coordinatesActivated(DebuggerRegistersProvider.this.current.reFindThread())) {
                DebuggerRegistersProvider.this.regsTableModel.fireTableDataChanged();
            }
        }

        private void registerValueChanged(AddressSpace space, TraceAddressSnapRange range, byte[] oldIsNull, byte[] newVal) {
            if (!this.isVisible(space, range)) {
                return;
            }
            this.refreshRange(range.getRange());
        }

        private void registerStateChanged(AddressSpace space, TraceAddressSnapRange range, TraceMemoryState oldState, TraceMemoryState newState) {
            if (!this.isVisible(space, range)) {
                return;
            }
            DebuggerRegistersProvider.this.recomputeViewKnown();
            this.refreshRange(range.getRange());
        }

        private void registerTypeAdded(AddressSpace space, TraceAddressSnapRange range, TraceCodeUnit oldIsNull, TraceCodeUnit newUnit) {
            if (!this.isVisible(space, range)) {
                return;
            }
            this.refreshRange(range.getRange());
        }

        private void registerTypeReplaced(AddressSpace space, TraceAddressSnapRange range, long oldTypeID, long newTypeID) {
            if (!this.isVisible(space, range)) {
                return;
            }
            this.refreshRange(range.getRange());
        }

        private void registerTypeLifespanChanged(AddressSpace space, TraceCodeUnit unit, Lifespan oldSpan, Lifespan newSpan) {
            if (!this.isVisible(space)) {
                return;
            }
            TraceProgramView view = DebuggerRegistersProvider.this.current.getView();
            if (view == null) {
                return;
            }
            TraceTimeViewport viewport = view.getViewport();
            if (viewport.containsAnyUpper(oldSpan) == viewport.containsAnyUpper(newSpan)) {
                return;
            }
            AddressRangeImpl range = new AddressRangeImpl(unit.getMinAddress(), unit.getMaxAddress());
            this.refreshRange((AddressRange)range);
        }

        private void registerTypeRemoved(AddressSpace space, TraceAddressSnapRange range, TraceCodeUnit oldUnit, TraceCodeUnit newIsNull) {
            if (!this.isVisible(space)) {
                return;
            }
            this.refreshRange(range.getRange());
        }

        private void threadDeleted(TraceThread thread) {
        }

        private void threadDestroyed(TraceThread thread, Lifespan oldSpan, Lifespan newSpan) {
        }
    }

    protected static class RegistersTableModel
    extends DefaultEnumeratedColumnTableModel<RegisterTableColumns, RegisterRow> {
        public RegistersTableModel(PluginTool tool) {
            super(tool, "Registers", RegisterTableColumns.class);
        }

        public List<RegisterTableColumns> defaultSortOrder() {
            return List.of(RegisterTableColumns.FAV, RegisterTableColumns.NUMBER);
        }

        protected TableColumnDescriptor<RegisterRow> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = super.createTableColumnDescriptor();
            for (DebuggerRegisterColumnFactory factory : ClassSearcher.getInstances(DebuggerRegisterColumnFactory.class)) {
                descriptor.addHiddenColumn(factory.create());
            }
            return descriptor;
        }
    }

    protected static enum RegisterTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<RegisterTableColumns, RegisterRow>
    {
        FAV("Fav", 1, Boolean.class, RegisterRow::isFavorite, RegisterRow::setFavorite, r -> true, ColumnSortState.SortDirection.DESCENDING),
        NUMBER("#", 1, Integer.class, RegisterRow::getNumber),
        NAME("Name", 40, String.class, RegisterRow::getName),
        VALUE("Value", 100, BigInteger.class, RegisterRow::getValue, RegisterRow::setValue, RegisterRow::isValueEditable, ColumnSortState.SortDirection.ASCENDING){
            private static final RegisterValueCellRenderer RENDERER = new RegisterValueCellRenderer();
            private static final SettingsDefinition[] DEFS = new SettingsDefinition[]{FormatSettingsDefinition.DEF_HEX};

            public GColumnRenderer<BigInteger> getRenderer() {
                return RENDERER;
            }

            public SettingsDefinition[] getSettingsDefinitions() {
                return DEFS;
            }
        }
        ,
        TYPE("Type", 40, DataType.class, RegisterRow::getDataType, RegisterRow::setDataType, r -> true, ColumnSortState.SortDirection.ASCENDING),
        REPR("Repr", 100, String.class, RegisterRow::getRepresentation, RegisterRow::setRepresentation, RegisterRow::isRepresentationEditable, ColumnSortState.SortDirection.ASCENDING);

        private final String header;
        private final int width;
        private final Function<RegisterRow, ?> getter;
        private final BiConsumer<RegisterRow, Object> setter;
        private final Predicate<RegisterRow> editable;
        private final Class<?> cls;
        private final ColumnSortState.SortDirection direction;

        private <T> RegisterTableColumns(String header, int width, Class<T> cls, Function<RegisterRow, T> getter) {
            this(header, width, cls, getter, null, null, ColumnSortState.SortDirection.ASCENDING);
        }

        private <T> RegisterTableColumns(String header, int width, Class<T> cls, Function<RegisterRow, T> getter, BiConsumer<RegisterRow, T> setter, Predicate<RegisterRow> editable, ColumnSortState.SortDirection direction) {
            this.header = header;
            this.width = width;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
            this.editable = editable;
            this.direction = direction;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(RegisterRow row) {
            return this.getter.apply(row);
        }

        public String getHeader() {
            return this.header;
        }

        public boolean isEditable(RegisterRow row) {
            return this.editable != null && this.editable.test(row);
        }

        public void setValueOf(RegisterRow row, Object value) {
            this.setter.accept(row, value);
        }

        public ColumnSortState.SortDirection defaultSortDirection() {
            return this.direction;
        }

        public int getPreferredWidth() {
            return this.width;
        }
    }

    class RegisterDataTypeEditor
    extends DataTypeTableCellEditor {
        public RegisterDataTypeEditor() {
            super(DebuggerRegistersProvider.this.plugin.getTool());
        }

        protected DataTypeParser.AllowedDataTypes getAllowed(int row, int column) {
            return DataTypeParser.AllowedDataTypes.FIXED_LENGTH;
        }

        protected boolean validateSelection(DataType dataType) {
            RegisterRow row = (RegisterRow)DebuggerRegistersProvider.this.regsTableModel.getModelData().get(DebuggerRegistersProvider.this.regsTable.getEditingRow());
            if (row == null) {
                return false;
            }
            return dataType.getLength() == row.getRegister().getMinimumByteSize();
        }

        protected DataType resolveSelection(DataType dataType) {
            if (dataType == null) {
                return null;
            }
            try (Transaction tx = DebuggerRegistersProvider.this.currentTrace.openTransaction("Resolve DataType");){
                DataType dataType2 = DebuggerRegistersProvider.this.currentTrace.getDataTypeManager().resolve(dataType, null);
                return dataType2;
            }
        }
    }

    static interface ClearRegisterType {
        public static final String NAME = "Clear Register Type";
        public static final String DESCRIPTION = "Clear the register's data type";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION);
        }
    }

    static interface RegisterTypeSettings {
        public static final String NAME = "Register Type Settings";
        public static final String DESCRIPTION = "Set the register's data type settings";
        public static final String HELP_ANCHOR = "type_settings";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    protected static class RegisterDataSettingsDialog
    extends DataSettingsDialog {
        public RegisterDataSettingsDialog(Data data) {
            super(data);
        }

        protected Settings getSettings() {
            return super.getSettings();
        }

        protected void okCallback() {
            super.okCallback();
        }
    }

    static class RegisterValueCellRenderer
    extends HexDefaultGColumnRenderer<BigInteger> {
        RegisterValueCellRenderer() {
        }

        public final Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            RegisterRow row = (RegisterRow)data.getRowObject();
            if (!row.isKnown()) {
                if (data.isSelected()) {
                    this.setForeground(COLOR_FOREGROUND_STALE_SEL);
                } else {
                    this.setForeground(COLOR_FOREGROUND_STALE);
                }
            } else if (row.isChanged()) {
                if (data.isSelected()) {
                    this.setForeground(COLOR_FOREGROUND_CHANGED_SEL);
                } else {
                    this.setForeground(COLOR_FOREGROUND_CHANGED);
                }
            }
            return this;
        }
    }
}

