/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.disassemble;

import ghidra.app.plugin.core.assembler.PatchDataAction;
import ghidra.app.plugin.core.debug.disassemble.DebuggerDisassemblerPlugin;
import ghidra.app.services.DebuggerControlService;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.program.TraceProgramView;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TracePatchDataAction
extends PatchDataAction {
    protected final DebuggerDisassemblerPlugin plugin;

    public TracePatchDataAction(DebuggerDisassemblerPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
    }

    protected boolean isApplicableToUnit(CodeUnit cu) {
        return super.isApplicableToUnit(cu) && cu instanceof TraceData;
    }

    protected void applyPatch(AddressRange rng, byte[] encoded) throws MemoryAccessException, CodeUnitInsertionException {
        Program program = this.getProgram();
        if (!(program instanceof TraceProgramView)) {
            return;
        }
        TraceProgramView view = (TraceProgramView)program;
        DebuggerControlService controlService = (DebuggerControlService)this.tool.getService(DebuggerControlService.class);
        if (controlService == null) {
            return;
        }
        DebuggerControlService.StateEditor editor = controlService.createStateEditor(view);
        Address address = this.getAddress();
        try {
            editor.setVariable(address, encoded).get(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new MemoryAccessException("Couldn't patch", (Throwable)e);
        }
    }
}

