/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.disassemble;

import ghidra.app.plugin.core.debug.disassemble.DisassemblyInjectInfo;
import ghidra.app.plugin.core.debug.disassemble.TraceDisassembleCommand;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import ghidra.util.classfinder.ExtensionPoint;

@DisassemblyInjectInfo(platforms={})
public interface DisassemblyInject
extends ExtensionPoint {
    default public DisassemblyInjectInfo getInfo() {
        DisassemblyInjectInfo info = this.getClass().getAnnotation(DisassemblyInjectInfo.class);
        if (info == null) {
            Msg.warn((Object)this, (Object)(String.valueOf(this.getClass()) + " is missing @" + DisassemblyInjectInfo.class.getSimpleName() + " annotation"));
            return DisassemblyInject.class.getAnnotation(DisassemblyInjectInfo.class);
        }
        return info;
    }

    default public boolean isApplicable(TracePlatform platform) {
        for (DisassemblyInjectInfo.PlatformInfo info : this.getInfo().platforms()) {
            if (!info.langID().equals(platform.getLanguage().getLanguageID().toString()) || !info.compilerID().isBlank() && !info.compilerID().equals(platform.getCompilerSpec().getCompilerSpecID().toString())) continue;
            return true;
        }
        return false;
    }

    default public int getPriority() {
        return this.getInfo().priority();
    }

    default public void pre(PluginTool tool, TraceDisassembleCommand command, TracePlatform platform, long snap, TraceThread thread, AddressSetView startSet, AddressSetView restricted) {
    }

    default public void post(PluginTool tool, TracePlatform platform, long snap, AddressSetView disassembled) {
    }
}

