/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.IntegerFieldRepresentation;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfsplus.BTKey;
import org.catacombae.hfsexplorer.types.hfsplus.HFSCatalogNodeID;

public class HFSPlusExtentKey
extends BTKey
implements StructElements {
    public static final byte DATA_FORK = 0;
    public static final byte RESOURCE_FORK = -1;
    private final byte[] keyLength = new byte[2];
    private final byte[] forkType = new byte[1];
    private final byte[] pad = new byte[1];
    private final HFSCatalogNodeID fileID;
    private final byte[] startBlock = new byte[4];

    public HFSPlusExtentKey(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.keyLength, 0, 2);
        System.arraycopy(data, offset + 2, this.forkType, 0, 1);
        System.arraycopy(data, offset + 3, this.pad, 0, 1);
        this.fileID = new HFSCatalogNodeID(data, offset + 4);
        System.arraycopy(data, offset + 8, this.startBlock, 0, 4);
    }

    public HFSPlusExtentKey(byte forkType, HFSCatalogNodeID fileID, int startBlock) {
        System.arraycopy(Util.toByteArrayBE((short)12), 0, this.keyLength, 0, 2);
        this.forkType[0] = forkType;
        this.pad[0] = 0;
        this.fileID = fileID;
        System.arraycopy(Util.toByteArrayBE(startBlock), 0, this.startBlock, 0, 4);
    }

    public int length() {
        return 12;
    }

    public short getKeyLength() {
        return Util.readShortBE(this.keyLength);
    }

    public byte getForkType() {
        return Util.readByteBE(this.forkType);
    }

    public byte getPad() {
        return Util.readByteBE(this.pad);
    }

    public HFSCatalogNodeID getFileID() {
        return this.fileID;
    }

    public int getStartBlock() {
        return Util.readIntBE(this.startBlock);
    }

    public int getUnsignedForkType() {
        return Util.unsign(this.getForkType());
    }

    public long getUnsignedStartBlock() {
        return Util.unsign(this.getStartBlock());
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " keyLength: " + this.getKeyLength());
        ps.println(prefix + " forkType: " + this.getForkType());
        ps.println(prefix + " pad: " + this.getPad());
        ps.println(prefix + " fileID: ");
        this.getFileID().print(ps, prefix + "  ");
        ps.println(prefix + " startBlock: " + this.getStartBlock());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusExtentKey:");
        this.printFields(ps, prefix);
    }

    public int compareTo(BTKey btk) {
        if (btk instanceof HFSPlusExtentKey) {
            HFSPlusExtentKey extKey = (HFSPlusExtentKey)btk;
            if (this.getFileID().toLong() == extKey.getFileID().toLong()) {
                if (this.getUnsignedForkType() == extKey.getUnsignedForkType()) {
                    if (this.getUnsignedStartBlock() == extKey.getUnsignedStartBlock()) {
                        return 0;
                    }
                    if (this.getUnsignedStartBlock() < extKey.getUnsignedStartBlock()) {
                        return -1;
                    }
                    return 1;
                }
                if (this.getUnsignedForkType() < extKey.getUnsignedForkType()) {
                    return -1;
                }
                return 1;
            }
            if (this.getFileID().toLong() < extKey.getFileID().toLong()) {
                return -1;
            }
            return 1;
        }
        return super.compareTo(btk);
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.length()];
        System.arraycopy(this.keyLength, 0, result, 0, 2);
        System.arraycopy(this.forkType, 0, result, 2, 1);
        System.arraycopy(this.pad, 0, result, 3, 1);
        System.arraycopy(Util.toByteArrayBE(this.fileID.toInt()), 0, result, 4, 4);
        System.arraycopy(this.startBlock, 0, result, 8, 4);
        return result;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder("HFSPlusExtentKey", "HFS+ extent key");
        db.addUIntBE("keyLength", this.keyLength, "Key length", "bytes");
        db.addUIntBE("forkType", this.forkType, "Fork type");
        db.addUIntBE("pad", this.pad, "Padding", IntegerFieldRepresentation.HEXADECIMAL);
        db.add("fileID", this.fileID.getStructElements(), "File ID");
        db.addUIntBE("startBlock", this.startBlock, "Start block number");
        return db.getResult();
    }
}

