/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.partitioning;

import java.io.PrintStream;
import java.util.LinkedList;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.partitioning.MBRPartition;
import org.catacombae.hfsexplorer.partitioning.Partition;

public class MasterBootRecord {
    public static final short MBR_SIGNATURE = 21930;
    public static final int IBM_EXTENDED_DATA_OFFSET = 394;
    public static final int OPTIONAL_DISK_SIGNATURE_OFFSET = 440;
    public static final int MBR_PARTITIONS_OFFSET = 446;
    protected final byte[] reserved1 = new byte[394];
    protected final byte[] optIBMExtendedData1 = new byte[9];
    protected final byte[] optIBMExtendedData2 = new byte[9];
    protected final byte[] optIBMExtendedData3 = new byte[9];
    protected final byte[] optIBMExtendedData4 = new byte[9];
    protected final byte[] reserved2 = new byte[10];
    protected final byte[] optDiskSignature = new byte[4];
    protected final byte[] reserved3 = new byte[2];
    protected final MBRPartition[] partitions = new MBRPartition[4];
    protected final byte[] mbrSignature = new byte[2];
    private final LinkedList<Partition> tempList = new LinkedList();

    public MasterBootRecord(byte[] data, int offset, int sectorSize) {
        System.arraycopy(data, offset + 0, this.reserved1, 0, this.reserved1.length);
        System.arraycopy(data, offset + 394 + 0, this.optIBMExtendedData1, 0, 9);
        System.arraycopy(data, offset + 394 + 9, this.optIBMExtendedData2, 0, 9);
        System.arraycopy(data, offset + 394 + 18, this.optIBMExtendedData3, 0, 9);
        System.arraycopy(data, offset + 394 + 27, this.optIBMExtendedData4, 0, 9);
        System.arraycopy(data, offset + 430, this.reserved2, 0, this.reserved2.length);
        System.arraycopy(data, offset + 440, this.optDiskSignature, 0, 4);
        System.arraycopy(data, offset + 444, this.reserved3, 0, this.reserved3.length);
        for (int i = 0; i < 4; ++i) {
            this.partitions[i] = new MBRPartition(data, offset + 446 + i * 16, sectorSize);
        }
        System.arraycopy(data, offset + 446 + 64, this.mbrSignature, 0, 2);
        if (!Util.arrayRegionsEqual(this.getBytes(), 0, MasterBootRecord.getStructSize(), data, offset, MasterBootRecord.getStructSize())) {
            throw new RuntimeException("Internal error!");
        }
    }

    public MasterBootRecord(MasterBootRecord source) {
        System.arraycopy(source.reserved1, 0, this.reserved1, 0, this.reserved1.length);
        System.arraycopy(source.optIBMExtendedData1, 0, this.optIBMExtendedData1, 0, this.optIBMExtendedData1.length);
        System.arraycopy(source.optIBMExtendedData2, 0, this.optIBMExtendedData2, 0, this.optIBMExtendedData2.length);
        System.arraycopy(source.optIBMExtendedData3, 0, this.optIBMExtendedData3, 0, this.optIBMExtendedData3.length);
        System.arraycopy(source.optIBMExtendedData4, 0, this.optIBMExtendedData4, 0, this.optIBMExtendedData4.length);
        System.arraycopy(source.reserved2, 0, this.reserved2, 0, this.reserved2.length);
        System.arraycopy(source.optDiskSignature, 0, this.optDiskSignature, 0, this.optDiskSignature.length);
        System.arraycopy(source.reserved3, 0, this.reserved3, 0, this.reserved3.length);
        for (int i = 0; i < 4; ++i) {
            this.partitions[i] = new MBRPartition(source.partitions[i]);
        }
        System.arraycopy(source.mbrSignature, 0, this.mbrSignature, 0, this.mbrSignature.length);
    }

    public static int getStructSize() {
        return 512;
    }

    public byte[] getOptionalIBMExtendedData1() {
        return Util.createCopy(this.optIBMExtendedData1);
    }

    public byte[] getOptionalIBMExtendedData2() {
        return Util.createCopy(this.optIBMExtendedData2);
    }

    public byte[] getOptionalIBMExtendedData3() {
        return Util.createCopy(this.optIBMExtendedData3);
    }

    public byte[] getOptionalIBMExtendedData4() {
        return Util.createCopy(this.optIBMExtendedData4);
    }

    public int getOptionalDiskSignature() {
        return Util.readIntBE(this.optDiskSignature);
    }

    public MBRPartition[] getPartitions() {
        MBRPartition[] result = new MBRPartition[this.partitions.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.partitions[i];
        }
        return result;
    }

    public short getMBRSignature() {
        return Util.readShortBE(this.mbrSignature);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " diskSignature: 0x" + Util.toHexStringBE(this.getOptionalDiskSignature()) + " (optional, and possibly incorrect)");
        ps.println(prefix + " partitions:");
        for (int i = 0; i < this.partitions.length; ++i) {
            ps.println(prefix + "  [" + i + "]:");
            if (this.partitions[i].isValid()) {
                this.partitions[i].print(ps, prefix + "   ");
                continue;
            }
            ps.println(prefix + "   [Invalid data]");
        }
        ps.println(prefix + " mbrSignature: 0x" + Util.toHexStringBE(this.getMBRSignature()));
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + this.getClass().getSimpleName() + ":");
        this.printFields(ps, prefix);
    }

    public boolean isValid() {
        return this.getMBRSignature() == 21930 && this.getValidPartitionCount() == 4;
    }

    public int getPartitionCount() {
        return this.partitions.length;
    }

    public int getValidPartitionCount() {
        int num = 0;
        for (MBRPartition mp : this.getPartitions()) {
            if (!mp.isValid()) continue;
            ++num;
        }
        return num;
    }

    public int getUsedPartitionCount() {
        int num = 0;
        for (MBRPartition mp : this.getPartitions()) {
            if (!mp.isUsed()) continue;
            ++num;
        }
        return num;
    }

    public Partition[] getPartitionEntries() {
        return this.getPartitions();
    }

    public Partition getPartitionEntry(int index) {
        MBRPartition p = this.partitions[index];
        if (p.isValid()) {
            return p;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public Partition[] getUsedPartitionEntries() {
        this.tempList.clear();
        for (MBRPartition mp : this.getPartitions()) {
            if (!mp.isUsed()) continue;
            this.tempList.addLast(mp);
        }
        return this.tempList.toArray(new Partition[this.tempList.size()]);
    }

    public byte[] getBytes() {
        byte[] result = new byte[512];
        int i = 0;
        System.arraycopy(this.reserved1, 0, result, i, this.reserved1.length);
        System.arraycopy(this.optIBMExtendedData1, 0, result, i += this.reserved1.length, this.optIBMExtendedData1.length);
        System.arraycopy(this.optIBMExtendedData2, 0, result, i += this.optIBMExtendedData1.length, this.optIBMExtendedData2.length);
        System.arraycopy(this.optIBMExtendedData3, 0, result, i += this.optIBMExtendedData2.length, this.optIBMExtendedData3.length);
        System.arraycopy(this.optIBMExtendedData4, 0, result, i += this.optIBMExtendedData3.length, this.optIBMExtendedData4.length);
        System.arraycopy(this.reserved2, 0, result, i += this.optIBMExtendedData4.length, this.reserved2.length);
        System.arraycopy(this.optDiskSignature, 0, result, i += this.reserved2.length, this.optDiskSignature.length);
        System.arraycopy(this.reserved3, 0, result, i += this.optDiskSignature.length, this.reserved3.length);
        i += this.reserved3.length;
        for (int j = 0; j < this.partitions.length; ++j) {
            byte[] curData = this.partitions[j].getBytes();
            System.arraycopy(curData, 0, result, i, curData.length);
            i += curData.length;
        }
        System.arraycopy(this.mbrSignature, 0, result, i, this.mbrSignature.length);
        if ((i += this.mbrSignature.length) != result.length) {
            throw new RuntimeException("Internal error!");
        }
        return result;
    }
}

