/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.gnu;

public enum GnuDemanglerFormat {
    AUTO("", Version.ALL),
    GNU("gnu", Version.DEPRECATED),
    LUCID("lucid", Version.DEPRECATED),
    ARM("arm", Version.DEPRECATED),
    HP("hp", Version.DEPRECATED),
    EDG("edg", Version.DEPRECATED),
    GNUV3("gnu-v3", Version.ALL),
    JAVA("java", Version.ALL),
    GNAT("gnat", Version.ALL),
    DLANG("dlang", Version.MODERN),
    RUST("rust", Version.MODERN);

    private final String format;
    private final Version version;

    private GnuDemanglerFormat(String format, Version version) {
        this.format = format;
        this.version = version;
    }

    public boolean isDeprecatedFormat() {
        return this.version == Version.DEPRECATED || this.version == Version.ALL;
    }

    public boolean isModernFormat() {
        return this.version == Version.MODERN || this.version == Version.ALL;
    }

    public boolean isAvailable(boolean isDeprecated) {
        return isDeprecated ? this.isDeprecatedFormat() : this.isModernFormat();
    }

    public String getFormat() {
        return this.format;
    }

    private static enum Version {
        DEPRECATED,
        MODERN,
        ALL;

    }
}

