/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import docking.action.MultiActionDockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.menu.ActionState;
import docking.menu.MultipleActionDockingToolbarButton;
import docking.widgets.EventTrigger;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import ghidra.util.exception.AssertException;
import help.Help;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import resources.icons.EmptyIcon;

public abstract class MultiStateDockingAction<T>
extends DockingAction {
    private static Icon EMPTY_ICON = new EmptyIcon(16, 16);
    private List<ActionState<T>> actionStates = new ArrayList<ActionState<T>>();
    private ActionState<T> currentState = null;
    private MultiActionDockingActionIf multiActionGenerator = context -> this.getStateActions();
    private MultipleActionDockingToolbarButton multipleButton;
    private Icon defaultIcon;
    private boolean useCheckboxForIcons;

    public MultiStateDockingAction(String name, String owner) {
        this(name, owner, KeyBindingType.INDIVIDUAL);
    }

    public MultiStateDockingAction(String name, String owner, KeyBindingType type) {
        super(name, owner, type);
        super.setToolBarData(new ToolBarData(null));
    }

    public abstract void actionStateChanged(ActionState<T> var1, EventTrigger var2);

    @Override
    public void actionPerformed(ActionContext context) {
        Swing.runLater(() -> this.multipleButton.showPopup());
    }

    public void setUseCheckboxForIcons(boolean useCheckboxForIcons) {
        this.useCheckboxForIcons = useCheckboxForIcons;
    }

    public void setDefaultIcon(Icon icon) {
        this.defaultIcon = icon;
    }

    protected List<ActionState<T>> getStates() {
        return this.actionStates;
    }

    private void updateStates() {
        List<ActionState<T>> newStates = this.getStates();
        if (newStates.equals(this.actionStates)) {
            return;
        }
        this.actionStates.clear();
        this.actionStates.addAll(newStates);
    }

    protected boolean isStateEnabled(ActionState<T> state) {
        return true;
    }

    protected List<DockingActionIf> getStateActions() {
        this.updateStates();
        ArrayList<DockingActionIf> actions = new ArrayList<DockingActionIf>(this.actionStates.size());
        for (ActionState<T> actionState : this.actionStates) {
            boolean isSelected = actionState.equals(this.currentState);
            DockingAction a = this.useCheckboxForIcons ? new ActionStateToggleAction(actionState, isSelected) : new ActionStateAction(actionState, isSelected);
            boolean isEnabled = this.isStateEnabled(actionState);
            a.setEnabled(isEnabled);
            actions.add(a);
        }
        return actions;
    }

    public void setGroup(String group) {
        ToolBarData tbd = this.getToolBarData();
        tbd.setToolBarGroup(group);
    }

    public void setSubGroup(String subGroup) {
        ToolBarData tbd = this.getToolBarData();
        tbd.setToolBarSubGroup(subGroup);
    }

    public void addActionState(ActionState<T> actionState) {
        this.actionStates.add(actionState);
        if (this.actionStates.size() == 1) {
            this.setCurrentActionState(actionState);
        }
    }

    public void setActionStates(List<ActionState<T>> newStates) {
        if (newStates.isEmpty()) {
            throw new IllegalArgumentException("You must provide at least one ActionState");
        }
        this.actionStates = new ArrayList<ActionState<T>>(newStates);
        this.setCurrentActionState(this.actionStates.get(0));
    }

    public T getCurrentUserData() {
        return this.currentState == null ? null : (T)this.currentState.getUserData();
    }

    public ActionState<T> getCurrentState() {
        return this.currentState;
    }

    public List<ActionState<T>> getAllActionStates() {
        return new ArrayList<ActionState<T>>(this.actionStates);
    }

    public void setCurrentActionStateByUserData(T t) {
        this.updateStates();
        for (ActionState<T> actionState : this.actionStates) {
            if (!actionState.getUserData().equals(t)) continue;
            this.doSetCurrentActionState(actionState, EventTrigger.API_CALL);
            return;
        }
        throw new AssertException("Attempted to set an action state by a user type not contained herein: " + String.valueOf(t));
    }

    public void setCurrentActionState(ActionState<T> actionState) {
        this.setCurrentActionStateWithTrigger(actionState, EventTrigger.API_CALL);
    }

    public void setCurrentActionStateWithTrigger(ActionState<T> actionState, EventTrigger trigger) {
        this.updateStates();
        this.doSetCurrentActionState(actionState, trigger);
    }

    protected void doSetCurrentActionState(ActionState<T> actionState, EventTrigger trigger) {
        if (!this.actionStates.contains(actionState)) {
            throw new IllegalArgumentException("Attempted to set actionState to unknown ActionState.");
        }
        this.currentState = actionState;
        this.setButtonState(actionState);
        ToolBarData tbd = this.getToolBarData();
        tbd.setIcon(this.getIcon(actionState));
        this.setDescription(this.getToolTipText());
        this.actionStateChanged(actionState, trigger);
    }

    private Icon getIcon(ActionState<T> actionState) {
        Icon icon = actionState.getIcon();
        if (icon != null) {
            return icon;
        }
        if (this.defaultIcon != null) {
            return this.defaultIcon;
        }
        return EMPTY_ICON;
    }

    @Override
    public JButton doCreateButton() {
        this.multipleButton = new MultipleActionDockingToolbarButton(this.multiActionGenerator);
        if (this.currentState != null) {
            this.setButtonState(this.currentState);
        }
        return this.multipleButton;
    }

    private void setButtonState(ActionState<T> actionState) {
        if (this.multipleButton == null) {
            return;
        }
        if (actionState == null) {
            this.multipleButton.setIcon(null);
            this.multipleButton.setToolTipText(null);
            return;
        }
        Icon icon = this.getIcon(actionState);
        this.multipleButton.setIcon(icon);
        this.multipleButton.setToolTipText(actionState.getName());
    }

    @Override
    public void setMenuBarData(MenuData newMenuData) {
        throw new UnsupportedOperationException();
    }

    protected void superSetMenuBarData(MenuData newMenuData) {
        super.setMenuBarData(newMenuData);
    }

    @Override
    public void setPopupMenuData(MenuData newMenuData) {
        throw new UnsupportedOperationException();
    }

    public String getToolTipText() {
        if (this.actionStates.isEmpty()) {
            return this.getName() + ": <no action states installed>";
        }
        return this.getName() + ": " + this.getCurrentState().getName();
    }

    protected void showPopup() {
        this.multipleButton.showPopup();
    }

    private class ActionStateToggleAction
    extends ToggleDockingAction {
        private final ActionState<T> actionState;

        private ActionStateToggleAction(ActionState<T> actionState, boolean isSelected) {
            super(actionState.getName(), "MultiStateAction");
            this.actionState = actionState;
            this.setSelected(isSelected);
            this.setMenuBarData(new MenuData(new String[]{actionState.getName()}));
            HelpLocation helpLocation = actionState.getHelpLocation();
            if (helpLocation != null) {
                this.setHelpLocation(helpLocation);
            } else {
                HelpLocation parentHelp = Help.getHelpService().getHelpLocation((Object)MultiStateDockingAction.this);
                this.setHelpLocation(parentHelp);
            }
        }

        @Override
        public String getInceptionInformation() {
            return MultiStateDockingAction.this.getInceptionInformation();
        }

        @Override
        public void actionPerformed(ActionContext context) {
            MultiStateDockingAction.this.setCurrentActionStateWithTrigger(this.actionState, EventTrigger.GUI_ACTION);
        }
    }

    private class ActionStateAction
    extends DockingAction {
        private final ActionState<T> actionState;

        private ActionStateAction(ActionState<T> actionState, boolean isSelected) {
            super(actionState.getName(), "MultiStateAction");
            this.actionState = actionState;
            this.setMenuBarData(new MenuData(new String[]{actionState.getName()}, actionState.getIcon()));
            HelpLocation helpLocation = actionState.getHelpLocation();
            if (helpLocation != null) {
                this.setHelpLocation(helpLocation);
            } else {
                HelpLocation parentHelp = Help.getHelpService().getHelpLocation((Object)MultiStateDockingAction.this);
                this.setHelpLocation(parentHelp);
            }
        }

        @Override
        public String getInceptionInformation() {
            return MultiStateDockingAction.this.getInceptionInformation();
        }

        @Override
        public void actionPerformed(ActionContext context) {
            MultiStateDockingAction.this.setCurrentActionStateWithTrigger(this.actionState, EventTrigger.GUI_ACTION);
        }
    }
}

