/*
 * Decompiled with CFR 0.152.
 */
package ghidra.xml;

import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.AbstractXmlPullParser;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlElementImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class NonThreadedXmlPullParserImpl
extends AbstractXmlPullParser {
    private LinkedList<XmlElement> queue = new LinkedList();
    private Locator locator;
    private HashMap<String, HashMap<String, String>> processingInstructions = new HashMap();
    private String name;

    public NonThreadedXmlPullParserImpl(File file, ErrorHandler errHandler, boolean validate) throws SAXException, IOException {
        this.name = file.getName();
        try (FileInputStream is = new FileInputStream(file);){
            this.fillQueue(file.getCanonicalPath(), file.getName(), is, errHandler, true, validate, false);
        }
    }

    public NonThreadedXmlPullParserImpl(String input, String inputName, ErrorHandler errHandler, boolean validate) throws SAXException {
        this.name = inputName;
        try {
            this.fillQueue(null, inputName, new ByteArrayInputStream(input.getBytes()), errHandler, false, validate, false);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public NonThreadedXmlPullParserImpl(InputStream input, String inputName, ErrorHandler errHandler, boolean validate) throws SAXException, IOException {
        this.name = inputName;
        this.fillQueue(null, inputName, input, errHandler, false, validate, false);
    }

    @Deprecated
    NonThreadedXmlPullParserImpl(File file, ErrorHandler errHandler, boolean validate, boolean reallyCreateNoncompliantDeprecated) throws SAXException, IOException {
        this.name = file.getName();
        try (FileInputStream is = new FileInputStream(file);){
            this.fillQueue(file.getCanonicalPath(), file.getName(), is, errHandler, true, validate, reallyCreateNoncompliantDeprecated);
        }
    }

    @Deprecated
    NonThreadedXmlPullParserImpl(String input, String inputName, ErrorHandler errHandler, boolean validate, boolean reallyCreateNoncompliantDeprecated) throws SAXException {
        this.name = inputName;
        try {
            this.fillQueue(null, inputName, new ByteArrayInputStream(input.getBytes()), errHandler, false, validate, reallyCreateNoncompliantDeprecated);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Deprecated
    NonThreadedXmlPullParserImpl(InputStream input, String inputName, ErrorHandler errHandler, boolean validate, boolean reallyCreateNoncompliantDeprecated) throws SAXException, IOException {
        this.name = inputName;
        this.fillQueue(null, inputName, input, errHandler, false, validate, reallyCreateNoncompliantDeprecated);
    }

    private void fillQueue(String filepath, String inputName, InputStream input, ErrorHandler errHandler, boolean closeStream, boolean validate, boolean reallyCreateNoncompliantDeprecated) throws SAXException, IOException {
        DefaultContentHandlerWrapper contentHandler = new DefaultContentHandlerWrapper(errHandler, reallyCreateNoncompliantDeprecated);
        try {
            SAXParserFactory saxParserFactory = XmlUtilities.createSecureSAXParserFactory(false);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", false);
            saxParserFactory.setFeature("http://xml.org/sax/features/validation", validate);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(input);
            inputSource.setSystemId(filepath);
            saxParser.parse(inputSource, (DefaultHandler)contentHandler);
        }
        catch (ParserConfigurationException e) {
            Msg.error((Object)((Object)this), (Object)e.getMessage());
            throw new SAXException(e);
        }
        finally {
            if (closeStream) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void dispose() {
    }

    public String getName() {
        return this.name;
    }

    public String getProcessingInstruction(String piName, String attribute) {
        Map map = this.processingInstructions.get(piName.toUpperCase());
        if (map == null) {
            return null;
        }
        return (String)map.get(attribute.toUpperCase());
    }

    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    public boolean isPullingContent() {
        return false;
    }

    public XmlElement next() {
        if (this.hasNext()) {
            return this.queue.removeFirst();
        }
        return null;
    }

    public XmlElement peek() {
        if (this.hasNext()) {
            return this.queue.getFirst();
        }
        return null;
    }

    public void setPullingContent(boolean pullingContent) {
        if (pullingContent) {
            throw new RuntimeException("this impl can't inject content");
        }
    }

    class DefaultContentHandlerWrapper
    extends DefaultHandler {
        private StringBuilder textBuf = new StringBuilder();
        private final ErrorHandler errorHandler;
        private final boolean reallyCreateNoncompliantDeprecated;
        private int level = -1;

        public DefaultContentHandlerWrapper(ErrorHandler errorHandler, boolean reallyCreateNoncompliantDeprecated) {
            this.errorHandler = errorHandler;
            this.reallyCreateNoncompliantDeprecated = reallyCreateNoncompliantDeprecated;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            if (this.errorHandler == null) {
                return;
            }
            this.errorHandler.error(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            if (this.errorHandler == null) {
                return;
            }
            this.errorHandler.fatalError(e);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            if (this.errorHandler == null) {
                return;
            }
            this.errorHandler.warning(e);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.textBuf.append(ch, start, length);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            NonThreadedXmlPullParserImpl.this.locator = locator;
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            HashMap<String, String> map = NonThreadedXmlPullParserImpl.this.processingInstructions.get(target = target.toUpperCase());
            if (map == null) {
                map = new HashMap();
                NonThreadedXmlPullParserImpl.this.processingInstructions.put(target, map);
            }
            StringTokenizer st = new StringTokenizer(data);
            while (st.hasMoreTokens()) {
                this.parseAttributeValue(map, st.nextToken());
            }
        }

        private void parseAttributeValue(HashMap<String, String> map, String attrValuePair) {
            String value;
            int ix = attrValuePair.indexOf(61);
            if (ix < 1 || ix == attrValuePair.length() - 1) {
                return;
            }
            String attr = attrValuePair.substring(0, ix);
            if ((value = attrValuePair.substring(++ix)).startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            map.put(attr.toUpperCase(), value.toUpperCase());
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.reallyCreateNoncompliantDeprecated) {
                qName = qName.toUpperCase();
            }
            NonThreadedXmlPullParserImpl.this.queue.add((XmlElement)new XmlElementImpl(false, true, qName, this.level, null, this.textBuf.toString(), NonThreadedXmlPullParserImpl.this.locator.getColumnNumber(), NonThreadedXmlPullParserImpl.this.locator.getLineNumber()));
            this.textBuf = new StringBuilder();
            --this.level;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.reallyCreateNoncompliantDeprecated) {
                qName = qName.toUpperCase();
            }
            ++this.level;
            this.textBuf.setLength(0);
            LinkedHashMap<String, String> attrMap = new LinkedHashMap<String, String>();
            int length = atts.getLength();
            for (int ii = 0; ii < length; ++ii) {
                attrMap.put(atts.getQName(ii), atts.getValue(ii));
            }
            NonThreadedXmlPullParserImpl.this.queue.add((XmlElement)new XmlElementImpl(true, false, qName, this.level, attrMap, null, NonThreadedXmlPullParserImpl.this.locator.getColumnNumber(), NonThreadedXmlPullParserImpl.this.locator.getLineNumber()));
        }
    }
}

