/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.action.MenuData;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.datatable.FrontendProjectTreeAction;
import ghidra.framework.main.datatable.ProjectDataContext;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.ProjectData;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class ProjectDataFollowLinkAction
extends FrontendProjectTreeAction {
    private FrontEndPlugin plugin;

    public ProjectDataFollowLinkAction(FrontEndPlugin plugin, String group) {
        super("Follow Link", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Follow Link"}, group));
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Follow_Link"));
    }

    protected void actionPerformed(ProjectDataContext context) {
        DomainFile referencedFile;
        boolean isFolder;
        String linkPath;
        List<DomainFile> selectedFiles = context.getSelectedFiles();
        if (selectedFiles.size() != 1) {
            return;
        }
        DomainFile file = selectedFiles.get(0);
        if (!file.isLink()) {
            return;
        }
        try {
            linkPath = LinkHandler.getAbsoluteLinkPath(file);
            if (linkPath == null) {
                Msg.showError((Object)((Object)this), (Component)context.getComponent(), (String)"Invalid Link", (Object)("Link-file failed to provide link path: " + String.valueOf(file)));
                return;
            }
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), (Component)context.getComponent(), (String)"Invalid Link", (Object)e.getMessage());
            return;
        }
        boolean isFolderLink = file.getLinkInfo().isFolderLink();
        if (GhidraURL.isGhidraURL(linkPath)) {
            try {
                this.plugin.showInViewedProject(new URL(linkPath), isFolderLink);
                return;
            }
            catch (MalformedURLException e) {
                Msg.error((Object)((Object)this), (Object)("Invalid link URL: " + e.getMessage()));
                return;
            }
        }
        ProjectData projectData = context.getProjectData();
        boolean bl = isFolder = isFolderLink && projectData.getFolder(linkPath) != null;
        if (!isFolder && (referencedFile = projectData.getFile(linkPath)) == null) {
            return;
        }
        this.plugin.showInProjectTree(context.getProjectData(), linkPath, isFolder);
    }

    @Override
    protected boolean isEnabledForContext(ProjectDataContext context) {
        if (!(context.getComponent() instanceof DataTree)) {
            return false;
        }
        if (context.getFolderCount() != 0 || context.getFileCount() != 1) {
            return false;
        }
        DomainFile file = context.getSelectedFiles().get(0);
        return file.isLink();
    }
}

