/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.datamgr.archive.DuplicateIdException;
import ghidra.app.plugin.core.datamgr.util.DataTypeArchiveUtility;
import ghidra.app.services.DataTypeManagerService;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.IBO32DataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MSDataTypeUtils {
    private MSDataTypeUtils() {
    }

    public static boolean is64Bit(Program program) {
        return program.getDefaultPointerSize() == 8;
    }

    public static StructureDataType getAlignedPack8Structure(DataTypeManager dataTypeManager, CategoryPath categoryPath, String structureName) {
        return MSDataTypeUtils.getAlignedPackedStructure(dataTypeManager, categoryPath, structureName, 8);
    }

    public static StructureDataType getAlignedPack4Structure(DataTypeManager dataTypeManager, CategoryPath categoryPath, String structureName) {
        return MSDataTypeUtils.getAlignedPackedStructure(dataTypeManager, categoryPath, structureName, 4);
    }

    private static StructureDataType getAlignedPackedStructure(DataTypeManager dataTypeManager, CategoryPath categoryPath, String structureName, int packValue) {
        StructureDataType struct = new StructureDataType(categoryPath, structureName, 0, dataTypeManager);
        struct.setPackingEnabled(true);
        if (packValue > 0) {
            struct.setExplicitPackingValue(packValue);
        }
        return struct;
    }

    public static DataType getEHStateDataType(Program program) {
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        TypedefDataType dt = new TypedefDataType(new CategoryPath("/"), "__ehstate_t", (DataType)new IntegerDataType((DataTypeManager)dtm), (DataTypeManager)dtm);
        return MSDataTypeUtils.getMatchingDataType(program, (DataType)dt);
    }

    public static DataType getPointerDisplacementDataType(Program program) {
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        TypedefDataType dt = new TypedefDataType(new CategoryPath("/"), "ptrdiff_t", (DataType)new IntegerDataType((DataTypeManager)dtm), (DataTypeManager)dtm);
        return MSDataTypeUtils.getMatchingDataType(program, (DataType)dt);
    }

    public static Structure getPMDDataType(Program program) {
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        IntegerDataType dt = MSDataTypeUtils.is64Bit(program) ? new IntegerDataType((DataTypeManager)dtm) : MSDataTypeUtils.getPointerDisplacementDataType(program);
        StructureDataType struct = MSDataTypeUtils.getAlignedPack4Structure((DataTypeManager)dtm, new CategoryPath("/"), "PMD");
        struct.add((DataType)dt, 4, "mdisp", null);
        struct.add((DataType)dt, 4, "pdisp", null);
        struct.add((DataType)dt, 4, "vdisp", null);
        return (Structure)MSDataTypeUtils.getMatchingDataType(program, (DataType)struct);
    }

    private static DataTypeManager getWinDTM(Program program) throws IOException, DuplicateIdException {
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager(program);
        DataTypeManagerService service = mgr.getDataTypeManagerService();
        List<String> archiveList = DataTypeArchiveUtility.getArchiveList(program);
        for (String archiveName : archiveList) {
            if (!archiveName.startsWith("windows_vs")) continue;
            return service.openDataTypeArchive(archiveName);
        }
        return null;
    }

    public static DataType getMatchingDataType(Program program, DataType comparisonDt) {
        ProgramBasedDataTypeManager programDTM = program.getDataTypeManager();
        DataType matchingDt = MSDataTypeUtils.findMatchingDataType(comparisonDt, (DataTypeManager)programDTM);
        if (matchingDt == null) {
            try {
                DataTypeManager winDTM = MSDataTypeUtils.getWinDTM(program);
                if (winDTM != null) {
                    matchingDt = MSDataTypeUtils.findMatchingDataType(comparisonDt, winDTM);
                }
            }
            catch (DuplicateIdException | IOException exception) {
                // empty catch block
            }
        }
        return matchingDt != null ? matchingDt.clone((DataTypeManager)programDTM) : comparisonDt;
    }

    private static DataType findMatchingDataType(DataType comparisonDt, DataTypeManager programDTM) {
        DataType oldDataType = programDTM.getDataType(comparisonDt.getCategoryPath(), comparisonDt.getName());
        if (oldDataType != null) {
            return oldDataType;
        }
        String name = comparisonDt.getName();
        ArrayList dataTypes = new ArrayList();
        programDTM.findDataTypes(name, dataTypes);
        for (DataType dataType : dataTypes) {
            if (dataType.getLength() != comparisonDt.getLength() || !dataType.isEquivalent(comparisonDt)) continue;
            return dataType;
        }
        return null;
    }

    public static Address getAbsoluteAddress(Program program, Address address) {
        PointerDataType refDt = new PointerDataType((DataTypeManager)program.getDataTypeManager());
        DumbMemBufferImpl compMemBuffer = new DumbMemBufferImpl(program.getMemory(), address);
        return (Address)refDt.getValue((MemBuffer)compMemBuffer, refDt.getDefaultSettings(), -1);
    }

    public static Address getReferencedAddress(Program program, Address address) {
        DataType refDt = MSDataTypeUtils.getReferenceDataType(program, null);
        int length = refDt.getLength();
        DumbMemBufferImpl compMemBuffer = new DumbMemBufferImpl(program.getMemory(), address);
        Object value = refDt.getValue((MemBuffer)compMemBuffer, refDt.getDefaultSettings(), length);
        return value instanceof Address ? (Address)value : null;
    }

    public static byte[] getBytes(Memory memory, Address startAddress, int length) throws InvalidDataTypeException {
        byte[] bytes = new byte[length];
        try {
            int bytesRead = memory.getBytes(startAddress, bytes);
            if (bytesRead != length) {
                throw new InvalidDataTypeException("Only read " + bytesRead + " bytes when trying to read " + length + ".");
            }
        }
        catch (MemoryAccessException e) {
            String message = "Couldn't read " + length + " bytes at " + String.valueOf(startAddress) + ".";
            throw new InvalidDataTypeException(message, (Throwable)e);
        }
        return bytes;
    }

    public static DataType getReferenceDataType(Program program, DataType referredToDataType) {
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        return MSDataTypeUtils.is64Bit(program) ? new IBO32DataType((DataTypeManager)dtm) : new PointerDataType(referredToDataType);
    }
}

