/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.nav;

import docking.widgets.TitledPanel;
import generic.theme.GColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class ListingPanelContainer
extends JPanel {
    private static final Color DISCONNECTED = new GColor("color.border.provider.disconnected");
    private JSplitPane splitPane;
    private TitledPanel leftTitlePanel;
    private TitledPanel rightTitlePanelPanel;
    private JComponent leftListingPanel;
    private JComponent northComponent;

    public ListingPanelContainer(JComponent leftListingPanel, boolean isConnected) {
        this.leftListingPanel = leftListingPanel;
        this.setLayout(new BorderLayout());
        this.add(leftListingPanel);
        this.setConnnected(isConnected);
    }

    public ListingPanelContainer(JComponent leftListingPanel, JComponent rightListingPanel, String leftTitle, String rightTitle) {
        this(leftListingPanel, false);
        this.setOtherPanel(rightListingPanel, leftTitle, rightTitle);
    }

    public void setConnnected(boolean isConnected) {
        if (!isConnected) {
            this.setBorder(BorderFactory.createLineBorder(DISCONNECTED, 2));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public void setOtherPanel(JComponent rightListingPanel, String leftTitle, String rightTitle) {
        this.removeAll();
        this.leftTitlePanel = new TitledPanel(leftTitle, this.leftListingPanel, 20);
        this.rightTitlePanelPanel = new TitledPanel(rightTitle, rightListingPanel, 20);
        this.splitPane = new JSplitPane(1, (Component)this.leftTitlePanel, (Component)this.rightTitlePanelPanel);
        this.splitPane.setDividerLocation(0.5);
        this.splitPane.setResizeWeight(0.5);
        this.add((Component)this.splitPane, "Center");
        if (this.northComponent != null) {
            this.add((Component)this.northComponent, "North");
        }
    }

    public void updateTitle(String newTitle) {
        if (this.leftTitlePanel != null) {
            this.leftTitlePanel.setName(newTitle);
        }
    }

    public void clearOtherPanel() {
        this.removeAll();
        this.add(this.leftListingPanel);
        if (this.northComponent != null) {
            this.add((Component)this.northComponent, "North");
        }
    }

    public void setOrientation(boolean isSideBySide) {
        this.splitPane.setOrientation(isSideBySide ? 1 : 0);
        this.splitPane.setDividerLocation(0.5);
    }

    public void setNorthPanel(JComponent comp) {
        if (this.northComponent != null) {
            this.remove(this.northComponent);
        }
        this.northComponent = comp;
        if (this.northComponent != null) {
            this.add((Component)this.northComponent, "North");
        }
    }

    public JComponent getNorthPanel() {
        return this.northComponent;
    }
}

