/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.layout;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.LayoutDecorator;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.layout.LayoutChangeListener;
import edu.uci.ics.jung.visualization.layout.LayoutEvent;
import edu.uci.ics.jung.visualization.layout.LayoutEventSupport;
import edu.uci.ics.jung.visualization.util.Caching;
import edu.uci.ics.jung.visualization.util.ChangeEventSupport;
import edu.uci.ics.jung.visualization.util.DefaultChangeEventSupport;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;

public class ObservableCachingLayout<V, E>
extends LayoutDecorator<V, E>
implements ChangeEventSupport,
Caching,
LayoutEventSupport<V, E> {
    protected ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);
    protected LoadingCache<V, Point2D> locations;
    private List<LayoutChangeListener<V, E>> layoutChangeListeners = new ArrayList<LayoutChangeListener<V, E>>();

    public ObservableCachingLayout(Layout<V, E> delegate) {
        super(delegate);
        Function chain = Functions.compose((Function)new Function<Point2D, Point2D>(){

            public Point2D apply(Point2D p) {
                return (Point2D)p.clone();
            }
        }, delegate);
        this.locations = CacheBuilder.newBuilder().build(CacheLoader.from((Function)chain));
    }

    public void step() {
        super.step();
        this.fireStateChanged();
    }

    public void initialize() {
        super.initialize();
        this.fireStateChanged();
    }

    public boolean done() {
        if (this.delegate instanceof IterativeContext) {
            return ((IterativeContext)this.delegate).done();
        }
        return true;
    }

    public void setLocation(V v, Point2D location) {
        super.setLocation(v, location);
        this.fireStateChanged();
        this.fireLayoutChanged(v);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    @Override
    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }

    public void setGraph(Graph<V, E> graph) {
        this.delegate.setGraph(graph);
    }

    @Override
    public void clear() {
        this.locations.invalidateAll();
    }

    @Override
    public void init() {
    }

    public Point2D apply(V v) {
        return (Point2D)this.locations.getUnchecked(v);
    }

    private void fireLayoutChanged(V v) {
        LayoutEvent evt = new LayoutEvent(v, this.getGraph());
        for (LayoutChangeListener listener : this.layoutChangeListeners) {
            listener.layoutChanged(evt);
        }
    }

    @Override
    public void addLayoutChangeListener(LayoutChangeListener<V, E> listener) {
        this.layoutChangeListeners.add(listener);
    }

    @Override
    public void removeLayoutChangeListener(LayoutChangeListener<V, E> listener) {
        this.layoutChangeListeners.remove(listener);
    }
}

