/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.opbehavior;

import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.utils.Utils;
import ghidra.util.exception.AssertException;
import java.math.BigInteger;

public class OpBehaviorIntSright
extends BinaryOpBehavior {
    public OpBehaviorIntSright() {
        super(31);
    }

    @Override
    public long evaluateBinary(int sizeout, int sizein, long in1, long in2) {
        long res;
        long maxShift = sizein * 8 - 1;
        if (in2 < 0L || in2 > maxShift) {
            if (Utils.signbit_negative((long)in1, (int)sizein)) {
                return Utils.calc_mask((int)sizein);
            }
            return 0L;
        }
        if (Utils.signbit_negative((long)in1, (int)sizein)) {
            res = in1 >> (int)in2;
            long mask = Utils.calc_mask((int)sizein);
            mask = mask >>> (int)in2 ^ mask;
            res |= mask;
        } else {
            res = in1 >>> (int)in2;
        }
        return res;
    }

    @Override
    public BigInteger evaluateBinary(int sizeout, int sizein, BigInteger in1, BigInteger in2) {
        if (in1.signum() < 0 || in2.signum() < 0) {
            throw new AssertException("Expected unsigned in values");
        }
        int signbit = sizein * 8 - 1;
        BigInteger maxShift = BigInteger.valueOf(signbit);
        if (in2.compareTo(maxShift) > 0) {
            in2 = maxShift;
        }
        if (in1.testBit(signbit)) {
            in1 = Utils.convertToSignedValue((BigInteger)in1, (int)sizein);
        }
        return in1.shiftRight(in2.intValue());
    }
}

