/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.ext4.Ext4XattrEntry;
import ghidra.file.formats.ext4.Ext4XattrIbodyHeader;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Ext4Xattributes {
    private List<Ext4XattrEntry> eaEntries;

    public static Ext4Xattributes readInodeXAttributes(BinaryReader reader, long endOfInode) throws IOException {
        Ext4XattrEntry eaEntry;
        if (reader.getPointerIndex() + 4L >= endOfInode) {
            return null;
        }
        Ext4XattrIbodyHeader eaHeader = new Ext4XattrIbodyHeader(reader);
        if (!eaHeader.isValid()) {
            return null;
        }
        long eaEntriesStart = reader.getPointerIndex();
        ArrayList<Ext4XattrEntry> eaEntries = new ArrayList<Ext4XattrEntry>();
        while (reader.getPointerIndex() < endOfInode && !(eaEntry = new Ext4XattrEntry(reader)).isEndOfListMarker()) {
            if (!eaEntry.isValid()) {
                Msg.debug(Ext4Xattributes.class, (Object)("Bad Ext4XattrEntry: " + reader.getPointerIndex()));
                break;
            }
            if (eaEntry.getE_value_offs() > 0 && eaEntry.getE_value_size() > 0) {
                eaEntry.setValue(reader.readByteArray(eaEntriesStart + (long)eaEntry.getE_value_offs(), eaEntry.getE_value_size()));
            }
            eaEntries.add(eaEntry);
        }
        return new Ext4Xattributes(eaEntries);
    }

    private Ext4Xattributes(List<Ext4XattrEntry> eaEntries) {
        this.eaEntries = eaEntries;
    }

    public Ext4XattrEntry getAttribute(String attributeName) {
        for (Ext4XattrEntry eaEntry : this.eaEntries) {
            if (!eaEntry.getName().equals(attributeName)) continue;
            return eaEntry;
        }
        return null;
    }
}

