/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDefSettingsDefinition;

public interface TypeDef
extends DataType {
    public boolean isAutoNamed();

    public void enableAutoNaming();

    public DataType getDataType();

    public DataType getBaseDataType();

    default public boolean isPointer() {
        return this.getBaseDataType() instanceof Pointer;
    }

    default public boolean hasSameTypeDefSettings(TypeDef dt) {
        SettingsDefinition[] defs2;
        SettingsDefinition[] defs1 = this.getSettingsDefinitions();
        if (defs1.length != (defs2 = dt.getSettingsDefinitions()).length) {
            return false;
        }
        Settings settings1 = this.getDefaultSettings();
        Settings settings2 = dt.getDefaultSettings();
        for (int i = 0; i < defs1.length; ++i) {
            SettingsDefinition def = defs1[i];
            if (!defs2[i].getClass().equals(def.getClass())) {
                return false;
            }
            if (!(def instanceof TypeDefSettingsDefinition) || def.hasSameValue(settings1, settings2)) continue;
            return false;
        }
        return true;
    }
}

