/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.StartInstructionValue;
import ghidra.pcodeCPort.slghsymbol.SpecificSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;

public class StartSymbol
extends SpecificSymbol {
    private AddrSpace const_space;
    private PatternExpression patexp;

    StartSymbol(Location location) {
        super(location);
        this.patexp = null;
    }

    @Override
    public PatternExpression getPatternExpression() {
        return this.patexp;
    }

    @Override
    public symbol_type getType() {
        return symbol_type.start_symbol;
    }

    public StartSymbol(Location location, String nm, AddrSpace cspc) {
        super(location, nm);
        this.const_space = cspc;
        this.patexp = new StartInstructionValue(location);
        this.patexp.layClaim();
    }

    @Override
    public void dispose() {
        if (this.patexp != null) {
            PatternExpression.release(this.patexp);
        }
    }

    @Override
    public VarnodeTpl getVarnode() {
        ConstTpl spc = new ConstTpl(this.const_space);
        ConstTpl off = new ConstTpl(ConstTpl.const_type.j_start);
        ConstTpl sz_zero = new ConstTpl();
        return new VarnodeTpl(this.location, spc, off, sz_zero);
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_START_SYM);
        encoder.writeUnsignedInteger(SlaFormat.ATTRIB_ID, this.id);
        encoder.closeElement(SlaFormat.ELEM_START_SYM);
    }

    @Override
    public void encodeHeader(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_START_SYM_HEAD);
        this.encodeSleighSymbolHeader(encoder);
        encoder.closeElement(SlaFormat.ELEM_START_SYM_HEAD);
    }
}

