/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.som.SomAuxHeader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SomExecAuxHeader
extends SomAuxHeader {
    private long execTextSize;
    private long execTextMem;
    private long execTextFile;
    private long execDataSize;
    private long execDataMem;
    private long execDataFile;
    private long execBssSize;
    private long execEntry;
    private long execFlags;
    private long execBssFill;

    public SomExecAuxHeader(BinaryReader reader) throws IOException {
        super(reader);
        this.execTextSize = reader.readNextUnsignedInt();
        this.execTextMem = reader.readNextUnsignedInt();
        this.execTextFile = reader.readNextUnsignedInt();
        this.execDataSize = reader.readNextUnsignedInt();
        this.execDataMem = reader.readNextUnsignedInt();
        this.execDataFile = reader.readNextUnsignedInt();
        this.execBssSize = reader.readNextUnsignedInt();
        this.execEntry = reader.readNextUnsignedInt();
        this.execFlags = reader.readNextUnsignedInt();
        this.execBssFill = reader.readNextUnsignedInt();
    }

    public long getExecTextSize() {
        return this.execTextSize;
    }

    public long getExecTextMem() {
        return this.execTextMem;
    }

    public long getExecTextFile() {
        return this.execTextFile;
    }

    public long getExecDataSize() {
        return this.execDataSize;
    }

    public long getExecDataMem() {
        return this.execDataMem;
    }

    public long getExecDataFile() {
        return this.execDataFile;
    }

    public long getExecBssSize() {
        return this.execBssSize;
    }

    public long getExecEntry() {
        return this.execEntry;
    }

    public long getExecFlags() {
        return this.execFlags;
    }

    public long getExecBssFill() {
        return this.execBssFill;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("som_exec_auxhdr", 0);
        struct.setPackingEnabled(true);
        struct.add(this.auxId.toDataType(), "som_auxhdr", null);
        struct.add(DWORD, "exec_tsize", "text size in bytes");
        struct.add(DWORD, "exec_tmem", "offset of text in memory");
        struct.add(DWORD, "exec_tfile", "location of text in file");
        struct.add(DWORD, "exec_dsize", "initialized data size in bytes");
        struct.add(DWORD, "exec_dmem", "offset of data in memory");
        struct.add(DWORD, "exec_dfile", "location of data in file");
        struct.add(DWORD, "exec_bsize", "uninitialized data (bss) size in bytes");
        struct.add(DWORD, "exec_entry", "offset of entrypoint");
        struct.add(DWORD, "exec_flags", "loader flags");
        struct.add(DWORD, "exec_bfill", "bss initialization value");
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

