/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ne;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.ne.Segment;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.address.SegmentedAddressSpace;
import java.io.IOException;

public class SegmentTable {
    private Segment[] segments;

    SegmentTable(BinaryReader reader, SegmentedAddress baseAddr, short index, short segmentCount, short shiftAlignCount) throws IOException {
        int curSegment;
        SegmentedAddressSpace space;
        long oldIndex = reader.getPointerIndex();
        reader.setPointerIndex(Short.toUnsignedInt(index));
        shiftAlignCount = (short)(1 << shiftAlignCount);
        int segmentCountInt = Short.toUnsignedInt(segmentCount);
        this.segments = new Segment[segmentCountInt];
        if (baseAddr != null) {
            space = (SegmentedAddressSpace)baseAddr.getAddressSpace();
            curSegment = baseAddr.getSegment();
        } else {
            space = null;
            curSegment = 0;
        }
        for (int i = 0; i < segmentCountInt; ++i) {
            this.segments[i] = new Segment(reader, shiftAlignCount, curSegment);
            int size = this.segments[i].getMinAllocSize() & 0xFFFF;
            if (size == 0) {
                size = 65536;
            }
            if (space != null) {
                SegmentedAddress endAddr = space.getAddress(curSegment, size - 1);
                curSegment = space.getNextOpenSegment((Address)endAddr);
                continue;
            }
            ++curSegment;
        }
        reader.setPointerIndex(oldIndex);
    }

    public Segment[] getSegments() {
        return this.segments;
    }
}

