/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeNode;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.util.List;
import javax.swing.Icon;
import resources.Icons;

public class MoreNode
extends SymbolTreeNode {
    private static Icon ICON = Icons.MAKE_SELECTION_ICON;
    private int count;
    private String name;

    MoreNode(String name, int count) {
        this.name = name;
        this.count = count;
    }

    public String getName() {
        return this.count + " more...";
    }

    @Override
    public boolean canCut() {
        return false;
    }

    @Override
    public boolean canPaste(List<GTreeNode> pastedNodes) {
        return false;
    }

    @Override
    public void setNodeCut(boolean isCut) {
        throw new UnsupportedOperationException("Cannot cut an organization node");
    }

    @Override
    public boolean isCut() {
        return false;
    }

    @Override
    public DataFlavor getNodeDataFlavor() {
        return null;
    }

    @Override
    public boolean supportsDataFlavors(DataFlavor[] dataFlavors) {
        return false;
    }

    @Override
    public Namespace getNamespace() {
        return null;
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        return null;
    }

    public Icon getIcon(boolean expanded) {
        return ICON;
    }

    public String getToolTip() {
        return "There are " + this.count + " nodes named \"" + this.name + "\" not being shown";
    }

    public boolean isLeaf() {
        return true;
    }

    void incrementCount() {
        ++this.count;
    }

    void decrementCount() {
        this.count = Math.max(0, --this.count);
    }

    boolean isEmpty() {
        return this.count == 0;
    }
}

