/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.VariableStorageConflicts;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Arrays;

class FunctionVariableStorageConflicts
extends VariableStorageConflicts {
    private Function function1;
    private Function function2;

    FunctionVariableStorageConflicts(Function function1, Function function2, boolean ignoreParamToParamConflicts, TaskMonitor monitor) throws CancelledException {
        super(Arrays.asList(function1.getAllVariables()), Arrays.asList(function2.getAllVariables()), ignoreParamToParamConflicts, monitor);
        this.function1 = function1;
        this.function2 = function2;
    }

    public boolean isConflicted(Variable var1, Variable var2) {
        if (var1 != null && var1.getFunction() != this.function1) {
            throw new IllegalArgumentException("var1 does not correspond to function1");
        }
        if (var2 != null && var2.getFunction() != this.function2) {
            throw new IllegalArgumentException("var2 does not correspond to function2");
        }
        return super.isConflicted(var1, var2);
    }
}

