/*
 * Decompiled with CFR 0.152.
 */
package docking.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;

public class StringTransferable
implements Transferable {
    private static final List<String> STRING_LITERAL_PREFIXES = List.of("\"", "u8\"", "u\"", "U\"", "L\"", "= \"");
    protected String data = null;
    private DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor};

    public StringTransferable(String data) {
        this.data = data.replaceAll("\u0000", "");
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DataFlavor.stringFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this.data;
    }

    public void removeOuterQuotesAndStandardStringPrefix() {
        if (this.data.length() < 2 || this.data.charAt(this.data.length() - 1) != '\"') {
            return;
        }
        for (String prefix : STRING_LITERAL_PREFIXES) {
            if (!this.data.startsWith(prefix)) continue;
            this.data = this.data.substring(prefix.length(), this.data.length() - 1);
            break;
        }
    }
}

