/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import java.util.NoSuchElementException;

public class RGB32EncodingSettingsDefinition
implements EnumSettingsDefinition,
TypeDefSettingsDefinition {
    public static final RGB32Encoding DEFAULT_ENCODING = RGB32Encoding.ARGB_8888;
    private static final String RGB32_ENCODING_SETTINGS_NAME = "rgb32";
    private static final String DESCRIPTION = "Specifies a 32-bit RGB Color Encoding";
    private static final String DISPLAY_NAME = "RGB32 Encoding";
    private static final String[] choices = new String[]{RGB32Encoding.ARGB_8888.name(), RGB32Encoding.RGBA_8888.name(), RGB32Encoding.BGRA_8888.name(), RGB32Encoding.ABGR_8888.name()};
    public static final RGB32EncodingSettingsDefinition DEF = new RGB32EncodingSettingsDefinition();

    private RGB32EncodingSettingsDefinition() {
    }

    public RGB32Encoding getRGBEncoding(Settings settings) {
        return RGB32Encoding.valueOf(this.getValueString(settings));
    }

    public int getChoice(Settings settings) {
        if (settings == null) {
            return 0;
        }
        Long value = settings.getLong(RGB32_ENCODING_SETTINGS_NAME);
        if (value == null) {
            return 0;
        }
        int choice = (int)value.longValue();
        try {
            if (choice >= 0 || choice < choices.length) {
                return choice;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return 0;
    }

    public String getValueString(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    public void setChoice(Settings settings, int choice) {
        try {
            if (choice > 0 || choice < choices.length) {
                settings.setLong(RGB32_ENCODING_SETTINGS_NAME, (long)choice);
                return;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        settings.clearSetting(RGB32_ENCODING_SETTINGS_NAME);
    }

    public void setRGBEncoding(Settings settings, RGB32Encoding encoding) {
        String encodingName = encoding.name();
        for (int i = 0; i < choices.length; ++i) {
            if (!choices[i].equals(encodingName)) continue;
            this.setChoice(settings, i);
            break;
        }
        throw new AssertionError((Object)("Missing RGB Encoding choice: " + String.valueOf((Object)encoding)));
    }

    public String[] getDisplayChoices(Settings settings) {
        return choices;
    }

    public String getName() {
        return DISPLAY_NAME;
    }

    public String getStorageKey() {
        return RGB32_ENCODING_SETTINGS_NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getDisplayChoice(int value, Settings s1) {
        return choices[value];
    }

    public void clear(Settings settings) {
        settings.clearSetting(RGB32_ENCODING_SETTINGS_NAME);
    }

    public void copySetting(Settings settings, Settings destSettings) {
        Long l = settings.getLong(RGB32_ENCODING_SETTINGS_NAME);
        if (l == null) {
            destSettings.clearSetting(RGB32_ENCODING_SETTINGS_NAME);
        } else {
            destSettings.setLong(RGB32_ENCODING_SETTINGS_NAME, l.longValue());
        }
    }

    public boolean hasValue(Settings setting) {
        return setting.getValue(RGB32_ENCODING_SETTINGS_NAME) != null;
    }

    public String getDisplayChoice(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    public void setDisplayChoice(Settings settings, String choice) {
        for (int i = 0; i < choices.length; ++i) {
            if (!choices[i].equals(choice)) continue;
            this.setChoice(settings, i);
            break;
        }
    }

    @Override
    public String getAttributeSpecification(Settings settings) {
        int choice = this.getChoice(settings);
        if (choice != 0) {
            return choices[choice];
        }
        return null;
    }

    public static enum RGB32Encoding {
        ARGB_8888,
        RGBA_8888,
        BGRA_8888,
        ABGR_8888;

    }
}

