/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.EmptyCodeBlockReferenceIterator;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class ExtCodeBlockImpl
extends AddressSet
implements CodeBlock {
    private static EmptyCodeBlockReferenceIterator EMPTY_ITERATOR = new EmptyCodeBlockReferenceIterator();
    private CodeBlockModel model;
    private Address extAddr;

    public ExtCodeBlockImpl(CodeBlockModel model, Address extAddr) {
        super(extAddr);
        this.model = model;
        this.extAddr = extAddr;
        if (!extAddr.isExternalAddress()) {
            throw new IllegalArgumentException("Expected external address");
        }
    }

    @Override
    public Address getFirstStartAddress() {
        return this.extAddr;
    }

    @Override
    public FlowType getFlowType() {
        return RefType.INVALID;
    }

    @Override
    public CodeBlockModel getModel() {
        return this.model;
    }

    @Override
    public String getName() {
        SymbolTable symTable = this.model.getProgram().getSymbolTable();
        Symbol s = symTable.getPrimarySymbol(this.extAddr);
        if (s != null) {
            return s.getName(true);
        }
        return this.extAddr.toString();
    }

    @Override
    public int getNumDestinations(TaskMonitor monitor) throws CancelledException {
        return 0;
    }

    @Override
    public CodeBlockReferenceIterator getDestinations(TaskMonitor monitor) throws CancelledException {
        return EMPTY_ITERATOR;
    }

    @Override
    public int getNumSources(TaskMonitor monitor) throws CancelledException {
        return this.model.getNumSources(this, monitor);
    }

    @Override
    public CodeBlockReferenceIterator getSources(TaskMonitor monitor) throws CancelledException {
        return this.model.getSources(this, monitor);
    }

    @Override
    public Address[] getStartAddresses() {
        return new Address[]{this.extAddr};
    }

    @Override
    public int hashCode() {
        return this.extAddr.hashCode();
    }
}

