/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import com.google.common.base.Objects;
import ghidra.graph.visualization.EdgeComparator;
import ghidra.graph.visualization.GraphRenderer;
import ghidra.graph.visualization.layout.JgtTidierTreeLayoutAlgorithm;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedVertex;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jungrapht.visualization.layout.algorithms.BalloonLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.CircleLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.EdgeAwareTreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.EiglspergerLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.FRLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.GEMLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.KKLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.RadialTreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.TidierRadialTreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.repulsion.BarnesHutFRRepulsion;
import org.jungrapht.visualization.layout.algorithms.repulsion.StandardFRRepulsion;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Layering;

class LayoutFunction
implements Function<String, LayoutAlgorithm.Builder<AttributedVertex, ?, ?>> {
    Predicate<AttributedEdge> favoredEdgePredicate;
    Comparator<AttributedEdge> edgeTypeComparator;

    LayoutFunction(GraphRenderer renderer) {
        this.edgeTypeComparator = new EdgeComparator(renderer);
        this.favoredEdgePredicate = edge -> Objects.equal((Object)edge.getEdgeType(), (Object)renderer.getFavoredEdgeType());
    }

    @Override
    public LayoutAlgorithm.Builder<AttributedVertex, ?, ?> apply(String name) {
        switch (name) {
            case "GEM": {
                return GEMLayoutAlgorithm.edgeAwareBuilder();
            }
            case "Force Balanced": {
                return KKLayoutAlgorithm.builder().preRelaxDuration(1000);
            }
            case "Force Directed": {
                return FRLayoutAlgorithm.builder().repulsionContractBuilder((StandardFRRepulsion.Builder)BarnesHutFRRepulsion.builder());
            }
            case "Circle": {
                return CircleLayoutAlgorithm.builder().reduceEdgeCrossing(false);
            }
            case "Compact Radial": {
                return TidierRadialTreeLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator);
            }
            case "Hierarchical MinCross Top Down": {
                return ((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).layering(Layering.TOP_DOWN);
            }
            case "Hierarchical MinCross Longest Path": {
                return ((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).layering(Layering.LONGEST_PATH);
            }
            case "Hierarchical MinCross Network Simplex": {
                return ((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).layering(Layering.NETWORK_SIMPLEX);
            }
            case "Hierarchical MinCross Coffman Graham": {
                return ((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).layering(Layering.COFFMAN_GRAHAM);
            }
            case "Vertical Hierarchical MinCross Top Down": {
                return ((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).favoredEdgePredicate(this.favoredEdgePredicate)).layering(Layering.TOP_DOWN);
            }
            case "Vertical Hierarchical MinCross Longest Path": {
                return ((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).favoredEdgePredicate(this.favoredEdgePredicate)).layering(Layering.LONGEST_PATH);
            }
            case "Vertical Hierarchical MinCross Network Simplex": {
                return ((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).favoredEdgePredicate(this.favoredEdgePredicate)).layering(Layering.NETWORK_SIMPLEX);
            }
            case "Vertical Hierarchical MinCross Coffman Graham": {
                return ((EiglspergerLayoutAlgorithm.Builder)((EiglspergerLayoutAlgorithm.Builder)EiglspergerLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator)).favoredEdgePredicate(this.favoredEdgePredicate)).layering(Layering.COFFMAN_GRAHAM);
            }
            case "Radial": {
                return RadialTreeLayoutAlgorithm.builder().verticalVertexSpacing(300);
            }
            case "Balloon": {
                return BalloonLayoutAlgorithm.builder().verticalVertexSpacing(300);
            }
            case "Hierarchical": {
                return EdgeAwareTreeLayoutAlgorithm.edgeAwareBuilder();
            }
        }
        return JgtTidierTreeLayoutAlgorithm.edgeAwareBuilder().edgeComparator(this.edgeTypeComparator);
    }
}

